/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.SparqlEndpointConfiguration;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.TripleSourceBase;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class SparqlTripleSource
extends TripleSourceBase
implements TripleSource {
    private boolean useASKQueries = true;

    SparqlTripleSource(Endpoint endpoint, FederationContext federationContext) {
        super(federationContext, endpoint);
        if (endpoint.getEndpointConfiguration() instanceof SparqlEndpointConfiguration) {
            SparqlEndpointConfiguration c = (SparqlEndpointConfiguration)endpoint.getEndpointConfiguration();
            this.useASKQueries = c.supportsASKQueries();
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(StatementPattern stmt, BindingSet bindings, FilterValueExpr filterExpr, QueryInfo queryInfo) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        throw new RuntimeException("NOT YET IMPLEMENTED.");
    }

    @Override
    public boolean hasStatements(Resource subj, IRI pred, Value obj, QueryInfo queryInfo, Resource ... contexts) throws RepositoryException {
        if (!this.useASKQueries) {
            StatementPattern st = new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj));
            Dataset dataset = FedXUtil.toDataset(contexts);
            try {
                return this.hasStatements(st, EmptyBindingSet.getInstance(), queryInfo, dataset);
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return super.hasStatements(subj, pred, obj, queryInfo, contexts);
    }

    @Override
    public boolean hasStatements(StatementPattern stmt, BindingSet bindings, QueryInfo queryInfo, Dataset dataset) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (this.useASKQueries) {
            boolean bl;
            block24: {
                String queryString = QueryStringUtil.askQueryString(stmt, bindings, dataset);
                RepositoryConnection conn = this.endpoint.getConnection();
                try {
                    boolean hasStatements;
                    BooleanQuery query = conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString, null);
                    this.configureInference((Query)query, queryInfo);
                    this.applyMaxExecutionTimeUpperBound((Operation)query);
                    this.monitorRemoteRequest();
                    bl = hasStatements = query.evaluate();
                    if (conn == null) break block24;
                }
                catch (Throwable query) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable hasStatements) {
                                query.addSuppressed(hasStatements);
                            }
                        }
                        throw query;
                    }
                    catch (Throwable ex) {
                        throw ExceptionUtil.traceExceptionSourceAndRepair(this.endpoint, ex, "Subquery: " + queryString);
                    }
                }
                conn.close();
            }
            return bl;
        }
        try (RepositoryConnection conn = this.endpoint.getConnection();){
            boolean bl;
            block25: {
                String queryString = QueryStringUtil.selectQueryStringLimit1(stmt, bindings, dataset);
                TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                this.configureInference((Query)query, queryInfo);
                this.applyMaxExecutionTimeUpperBound((Operation)query);
                this.monitorRemoteRequest();
                TupleQueryResult qRes = query.evaluate();
                try {
                    boolean hasStatements;
                    bl = hasStatements = qRes.hasNext();
                    if (qRes == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (qRes != null) {
                            try {
                                qRes.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        throw ExceptionUtil.traceExceptionSourceAndRepair(this.endpoint, ex, "Subquery: " + queryString);
                    }
                }
                qRes.close();
            }
            return bl;
        }
    }

    @Override
    public boolean hasStatements(ExclusiveTupleExpr expr, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (!this.useASKQueries) {
            try (RepositoryConnection conn = this.endpoint.getConnection();){
                boolean bl;
                block16: {
                    String queryString = QueryStringUtil.selectQueryStringLimit1(expr, bindings, expr.getQueryInfo().getDataset());
                    TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                    this.configureInference((Query)query, expr.getQueryInfo());
                    this.applyMaxExecutionTimeUpperBound((Operation)query);
                    this.monitorRemoteRequest();
                    TupleQueryResult qRes = query.evaluate();
                    try {
                        boolean hasStatements;
                        bl = hasStatements = qRes.hasNext();
                        if (qRes == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (qRes != null) {
                                try {
                                    qRes.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable ex) {
                            throw ExceptionUtil.traceExceptionSourceAndRepair(this.endpoint, ex, "Subquery: " + queryString);
                        }
                    }
                    qRes.close();
                }
                return bl;
            }
        }
        return super.hasStatements(expr, bindings);
    }

    @Override
    public boolean usePreparedQuery(StatementPattern stmt, QueryInfo queryInfo) {
        return true;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(TupleExpr preparedQuery, BindingSet bindings, FilterValueExpr filterExpr, QueryInfo queryInfo) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        throw new RuntimeException("NOT YET IMPLEMENTED.");
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, QueryInfo queryInfo, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            this.monitorRemoteRequest();
            RepositoryResult repoResult = conn.getStatements(subj, pred, obj, queryInfo.getIncludeInferred(), contexts);
            resultHolder.set(new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)repoResult){

                protected QueryEvaluationException convert(Exception ex) {
                    if (ex instanceof QueryEvaluationException) {
                        return (QueryEvaluationException)ex;
                    }
                    return new QueryEvaluationException((Throwable)ex);
                }
            });
        });
    }

    public String toString() {
        return "Sparql Triple Source: Endpoint - " + this.endpoint.getId();
    }
}

