/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadPrefReadWriteLockManager;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSail
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSail.class);
    private static final Model DASH_CONSTANTS;
    final boolean experimentalSparqlValidation;
    private SailRepository shapesRepo;
    private final ReadPrefReadWriteLockManager lockManager = new ReadPrefReadWriteLockManager();
    private transient Thread threadHoldingWriteLock;
    private boolean parallelValidation = true;
    private boolean undefinedTargetValidatesAllSubjects = false;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean ignoreNoShapesLoadedException = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean rdfsSubClassReasoning = true;
    private boolean serializableValidation = true;
    private boolean performanceLogging = false;
    private boolean eclipseRdf4jShaclExtensions = false;
    private boolean dashDataShapes = false;
    private long validationResultsLimitTotal = -1L;
    private long validationResultsLimitPerConstraint = -1L;
    private static final SchemaCachingRDFSInferencer shaclVocabulary;
    private static final IRI shaclVocabularyGraph;
    private final ExecutorService[] executorService = new ExecutorService[1];
    private transient ShaclSailConnection currentConnection;
    private transient boolean multipleConcurrentConnections;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    private static SchemaCachingRDFSInferencer createShaclVocbulary() throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(ShaclSail.class.getClassLoader().getResourceAsStream("shacl-sparql-inference/shaclVocabulary.ttl"));){
            SchemaCachingRDFSInferencer schemaCachingRDFSInferencer = new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore());
            try (SchemaCachingRDFSInferencerConnection connection = schemaCachingRDFSInferencer.getConnection();){
                connection.begin((IsolationLevel)IsolationLevels.NONE);
                Model model = Rio.parse((InputStream)in, (String)"", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
                model.forEach(s -> connection.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{shaclVocabularyGraph}));
                connection.commit();
            }
            SchemaCachingRDFSInferencer schemaCachingRDFSInferencer2 = schemaCachingRDFSInferencer;
            return schemaCachingRDFSInferencer2;
        }
    }

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
        ReferenceQueue<ShaclSail> objectReferenceQueue = new ReferenceQueue<ShaclSail>();
        this.startMonitoring(objectReferenceQueue, new PhantomReference<ShaclSail>(this, objectReferenceQueue), this.initialized, this.executorService);
        this.experimentalSparqlValidation = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.sail.shacl.experimentalSparqlValidation"));
    }

    public ShaclSail() {
        ReferenceQueue<ShaclSail> objectReferenceQueue = new ReferenceQueue<ShaclSail>();
        this.startMonitoring(objectReferenceQueue, new PhantomReference<ShaclSail>(this, objectReferenceQueue), this.initialized, this.executorService);
        this.experimentalSparqlValidation = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.sail.shacl.experimentalSparqlValidation"));
    }

    synchronized void closeConnection(ShaclSailConnection connection) {
        if (connection == this.currentConnection) {
            this.currentConnection = null;
        }
    }

    synchronized boolean usesSingleConnection() {
        return !this.multipleConcurrentConnections;
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.AND, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE, SHACL.MIN_EXCLUSIVE, SHACL.MIN_INCLUSIVE, SHACL.MAX_EXCLUSIVE, SHACL.MAX_INCLUSIVE, SHACL.CLASS, SHACL.TARGET_NODE, SHACL.DEACTIVATED, SHACL.TARGET_SUBJECTS_OF, SHACL.IN, SHACL.UNIQUE_LANG, SHACL.NOT, SHACL.TARGET_OBJECTS_OF, SHACL.HAS_VALUE, SHACL.TARGET_PROP, SHACL.INVERSE_PATH, SHACL.NODE, SHACL.QUALIFIED_MAX_COUNT, SHACL.QUALIFIED_MIN_COUNT, SHACL.QUALIFIED_VALUE_SHAPE, DASH.hasValueIn, RSX.targetShape);
    }

    public void initialize() throws SailException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        super.initialize();
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (super.getBaseSail().getDataDir() != null) {
            String path = super.getBaseSail().getDataDir().getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path + "/shapes-graph/";
            logger.info("Shapes will be persisted in: " + path);
            this.shapesRepo = new SailRepository((Sail)new MemoryStore(new File(path)));
        } else {
            this.shapesRepo = new SailRepository((Sail)new MemoryStore());
        }
        this.shapesRepo.init();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            shapesRepoConnection.begin((IsolationLevel)IsolationLevels.NONE);
            shapesRepoConnection.commit();
        }
        assert (this.executorService[0] == null);
    }

    @InternalUseOnly
    public List<Shape> getShapes(RepositoryConnection shapesRepoConnection) throws SailException {
        List<Shape> shapes;
        SailRepository shapesRepoWithReasoning = new SailRepository((Sail)SchemaCachingRDFSInferencer.fastInstantiateFrom((SchemaCachingRDFSInferencer)shaclVocabulary, (NotifyingSail)new MemoryStore(), (boolean)false));
        shapesRepoWithReasoning.init();
        try (SailRepositoryConnection shapesRepoWithReasoningConnection = shapesRepoWithReasoning.getConnection();){
            shapesRepoWithReasoningConnection.begin((IsolationLevel)IsolationLevels.NONE);
            try (RepositoryResult statements = shapesRepoConnection.getStatements(null, null, null, false, new Resource[0]);){
                shapesRepoWithReasoningConnection.add(statements, new Resource[0]);
            }
            this.enrichShapes(shapesRepoWithReasoningConnection);
            shapesRepoWithReasoningConnection.commit();
            shapes = Shape.Factory.getShapes((RepositoryConnection)shapesRepoWithReasoningConnection, this);
        }
        shapesRepoWithReasoning.shutDown();
        return shapes;
    }

    private void forceRefreshShapes() {
        if (this.shapesRepo != null) {
            try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
                shapesRepoConnection.begin(new TransactionSetting[]{IsolationLevels.NONE, TransactionSettings.ValidationApproach.Bulk});
                shapesRepoConnection.commit();
            }
        }
    }

    public synchronized void shutDown() throws SailException {
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (this.executorService[0] != null) {
            this.executorService[0].shutdown();
            boolean terminated = false;
            try {
                terminated = this.executorService[0].awaitTermination(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!terminated) {
                this.executorService[0].shutdownNow();
                logger.error("Shutdown ShaclSail while validation is still running.");
            }
        }
        this.initialized.set(false);
        this.executorService[0] = null;
        super.shutDown();
    }

    synchronized <T> Future<T> submitRunnableToExecutorService(Callable<T> runnable) {
        if (this.executorService[0] == null) {
            this.executorService[0] = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            });
        }
        return this.executorService[0].submit(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyingSailConnection getConnection() throws SailException {
        ShaclSailConnection shaclSailConnection = new ShaclSailConnection(this, super.getConnection(), (SailConnection)super.getConnection(), (SailConnection)super.getConnection(), (SailConnection)super.getConnection(), this.shapesRepo.getConnection());
        ShaclSail shaclSail = this;
        synchronized (shaclSail) {
            if (this.currentConnection == null) {
                this.currentConnection = shaclSailConnection;
            } else {
                this.multipleConcurrentConnections = true;
            }
        }
        return shaclSailConnection;
    }

    private void enrichShapes(SailRepositoryConnection shaclSailConnection) {
        if (shaclSailConnection.isEmpty()) {
            return;
        }
        shaclSailConnection.add((Iterable)DASH_CONSTANTS, new Resource[0]);
        this.implicitTargetClass(shaclSailConnection);
    }

    private void implicitTargetClass(SailRepositoryConnection shaclSailConnection) {
        try (Stream stream = shaclSailConnection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0]).stream();){
            stream.map(Statement::getSubject).filter(s -> shaclSailConnection.hasStatement(s, RDF.TYPE, (Value)SHACL.NODE_SHAPE, true, new Resource[0]) || shaclSailConnection.hasStatement(s, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, true, new Resource[0])).forEach(s -> shaclSailConnection.add(s, SHACL.TARGET_CLASS, (Value)s, new Resource[0]));
        }
    }

    Lock acquireExclusiveWriteLock(Lock lock) {
        if (lock != null && lock.isActive()) {
            return lock;
        }
        assert (lock == null);
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection also tries to modify the shapes!");
        }
        try {
            Lock writeLock = this.lockManager.getWriteLock();
            this.threadHoldingWriteLock = Thread.currentThread();
            return writeLock;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Lock releaseExclusiveWriteLock(Lock lock) {
        assert (lock != null);
        this.threadHoldingWriteLock = null;
        lock.release();
        return null;
    }

    Lock acquireReadLock() {
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection calls commit()!");
        }
        try {
            return this.lockManager.getReadLock();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Lock releaseReadLock(Lock lock) {
        assert (lock != null);
        lock.release();
        return null;
    }

    public void setGlobalLogValidationExecution(boolean loggingEnabled) {
        GlobalValidationExecutionLogging.loggingEnabled = loggingEnabled;
    }

    public boolean isGlobalLogValidationExecution() {
        return GlobalValidationExecutionLogging.loggingEnabled;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    @Deprecated
    public void setUndefinedTargetValidatesAllSubjects(boolean undefinedTargetValidatesAllSubjects) {
        this.undefinedTargetValidatesAllSubjects = undefinedTargetValidatesAllSubjects;
    }

    @Deprecated
    public boolean isUndefinedTargetValidatesAllSubjects() {
        return this.undefinedTargetValidatesAllSubjects;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public void disableValidation() {
        this.validationEnabled = false;
    }

    public void enableValidation() {
        this.forceRefreshShapes();
        this.validationEnabled = true;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    @Deprecated
    public boolean isIgnoreNoShapesLoadedException() {
        return this.ignoreNoShapesLoadedException;
    }

    @Deprecated
    public void setIgnoreNoShapesLoadedException(boolean ignoreNoShapesLoadedException) {
        this.ignoreNoShapesLoadedException = ignoreNoShapesLoadedException;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isSerializableValidation() {
        if (this.getBaseSail() instanceof SchemaCachingRDFSInferencer) {
            if (this.serializableValidation) {
                logger.warn("SchemaCachingRDFSInferencer is not supported when using serializable validation!");
            }
            return false;
        }
        return this.serializableValidation;
    }

    public void setSerializableValidation(boolean serializableValidation) {
        this.serializableValidation = serializableValidation;
    }

    private static String resourceAsString(String s) throws IOException {
        try (InputStream resourceAsStream = ShaclSail.class.getClassLoader().getResourceAsStream(s);){
            String string = IOUtils.toString((InputStream)Objects.requireNonNull(resourceAsStream), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private static Model resourceAsModel(String s) throws IOException {
        try (InputStream resourceAsStream = ShaclSail.class.getClassLoader().getResourceAsStream(s);){
            Model model = Rio.parse((InputStream)resourceAsStream, (String)"", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
            return model;
        }
    }

    private void startMonitoring(ReferenceQueue<ShaclSail> referenceQueue, Reference<ShaclSail> ref, AtomicBoolean initialized, ExecutorService[] executorService) {
        ExecutorService ex = Executors.newSingleThreadExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
        ex.execute(() -> {
            while (referenceQueue.poll() != ref) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (ref.get() != null) {
                return;
            }
            if (initialized.get()) {
                logger.error("ShaclSail was garbage collected without shutdown() having been called first.");
            }
            if (executorService[0] != null) {
                executorService[0].shutdownNow();
            }
        });
        ex.shutdown();
    }

    @InternalUseOnly
    public List<Shape> getCurrentShapes() {
        try (SailRepositoryConnection connection = this.shapesRepo.getConnection();){
            List<Shape> list = this.getShapes((RepositoryConnection)connection);
            return list;
        }
    }

    @Experimental
    public void setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
        this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
        this.forceRefreshShapes();
    }

    @Experimental
    public boolean isEclipseRdf4jShaclExtensions() {
        return this.eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public void setDashDataShapes(boolean dashDataShapes) {
        this.dashDataShapes = dashDataShapes;
        this.forceRefreshShapes();
    }

    @Experimental
    public boolean isDashDataShapes() {
        return this.dashDataShapes;
    }

    public long getValidationResultsLimitPerConstraint() {
        return this.validationResultsLimitPerConstraint;
    }

    public long getEffectiveValidationResultsLimitPerConstraint() {
        if (this.validationResultsLimitPerConstraint < 0L) {
            return this.validationResultsLimitTotal;
        }
        if (this.validationResultsLimitTotal >= 0L) {
            return Math.min(this.validationResultsLimitTotal, this.validationResultsLimitPerConstraint);
        }
        return this.validationResultsLimitPerConstraint;
    }

    public void setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
        this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
    }

    public long getValidationResultsLimitTotal() {
        return this.validationResultsLimitTotal;
    }

    public void setValidationResultsLimitTotal(long validationResultsLimitTotal) {
        this.validationResultsLimitTotal = validationResultsLimitTotal;
    }

    public IsolationLevel getDefaultIsolationLevel() {
        return super.getDefaultIsolationLevel();
    }

    boolean hasShapes() {
        try (SailRepositoryConnection connection = this.shapesRepo.getConnection();){
            boolean bl;
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            try {
                bl = !connection.isEmpty();
            }
            catch (Throwable throwable) {
                connection.commit();
                throw throwable;
            }
            connection.commit();
            return bl;
        }
    }

    static {
        shaclVocabularyGraph = Values.iri((String)"http://rdf4j.org/schema/rdf4j#", (String)"shaclVocabularyGraph");
        try {
            DASH_CONSTANTS = ShaclSail.resourceAsModel("shacl-sparql-inference/dashConstants.ttl");
            shaclVocabulary = ShaclSail.createShaclVocbulary();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class TransactionSettings {
        private final String value;

        TransactionSettings(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static final class ValidationApproach
        extends Enum<ValidationApproach>
        implements TransactionSetting {
            public static final /* enum */ ValidationApproach Disabled = new ValidationApproach("Disabled", 0);
            public static final /* enum */ ValidationApproach Bulk = new ValidationApproach("Bulk", 1);
            public static final /* enum */ ValidationApproach Auto = new ValidationApproach("Auto", 2);
            private final String value;
            private final int priority;
            private static final /* synthetic */ ValidationApproach[] $VALUES;

            public static ValidationApproach[] values() {
                return (ValidationApproach[])$VALUES.clone();
            }

            public static ValidationApproach valueOf(String name) {
                return Enum.valueOf(ValidationApproach.class, name);
            }

            private ValidationApproach(String value, int priority) {
                this.value = value;
                this.priority = priority;
            }

            public String getName() {
                return ValidationApproach.class.getCanonicalName();
            }

            public String getValue() {
                return this.value;
            }

            public static ValidationApproach getHighestPriority(ValidationApproach v1, ValidationApproach v2) {
                assert (v1 != null || v2 != null);
                if (v1 == null) {
                    return v2;
                }
                if (v2 == null) {
                    return v1;
                }
                if (v1.priority < v2.priority) {
                    return v1;
                }
                return v2;
            }

            static {
                $VALUES = new ValidationApproach[]{Disabled, Bulk, Auto};
            }
        }

        @Experimental
        public static enum PerformanceHint implements TransactionSetting
        {
            ParallelValidation("ParallelValidation"),
            SerialValidation("SerialValidation"),
            CacheEnabled("CacheEnabled"),
            CacheDisabled("CacheDisabled");

            private final String value;

            private PerformanceHint(String value) {
                this.value = value;
            }

            public String getName() {
                return PerformanceHint.class.getCanonicalName();
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

