/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class MemoryStoreConnection
extends SailSourceConnection {
    protected final MemoryStore sail;
    private volatile DefaultSailChangedEvent sailChangedEvent;

    protected MemoryStoreConnection(MemoryStore sail) {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.sail = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)sail);
    }

    protected void startTransactionInternal() throws SailException {
        if (!this.sail.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        super.startTransactionInternal();
        this.sail.cancelSyncTask();
    }

    protected void commitInternal() throws SailException {
        super.commitInternal();
        this.sail.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
        this.sail.scheduleSyncTask();
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.sail);
    }

    protected void rollbackInternal() throws SailException {
        super.rollbackInternal();
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.sail);
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public MemoryStore getSail() {
        return this.sail;
    }
}

