/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;

public class HTTPRepository
extends AbstractRepository
implements HttpClientDependent,
SessionManagerDependent {
    private volatile HttpClientSessionManager sessionManager;
    private volatile SharedHttpClientSessionManager dependentSessionManager;
    private String username;
    private String password;
    private String serverURL;
    private String repositoryURL;
    private RDFFormat rdfFormat;
    private TupleQueryResultFormat tupleFormat;
    private File dataDir;
    private volatile Boolean compatibleMode = null;
    private volatile Map<String, String> additionalHttpHeaders = Collections.emptyMap();

    private HTTPRepository() {
    }

    public HTTPRepository(String serverURL, String repositoryID) {
        this();
        this.serverURL = serverURL;
        this.repositoryURL = Protocol.getRepositoryLocation((String)serverURL, (String)repositoryID);
    }

    public HTTPRepository(String repositoryURL) {
        this();
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (!matcher.matches() || matcher.groupCount() != 1) {
            throw new IllegalArgumentException("URL must be to a RDF4J Repository (not just the server)");
        }
        this.serverURL = matcher.group(1);
        this.repositoryURL = repositoryURL;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientSessionManager getHttpClientSessionManager() {
        HttpClientSessionManager result = this.sessionManager;
        if (result == null) {
            HTTPRepository hTTPRepository = this;
            synchronized (hTTPRepository) {
                result = this.sessionManager;
                if (result == null) {
                    this.dependentSessionManager = new SharedHttpClientSessionManager();
                    this.sessionManager = this.dependentSessionManager;
                    result = this.dependentSessionManager;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        HTTPRepository hTTPRepository = this;
        synchronized (hTTPRepository) {
            this.sessionManager = client;
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentSessionManager;
            this.dependentSessionManager = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return Collections.unmodifiableMap(this.additionalHttpHeaders);
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders == null ? Collections.emptyMap() : additionalHttpHeaders;
    }

    public final HttpClient getHttpClient() {
        return this.getHttpClientSessionManager().getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager toSetDependentSessionManager = this.dependentSessionManager;
        if (toSetDependentSessionManager == null) {
            this.getHttpClientSessionManager();
            toSetDependentSessionManager = this.dependentSessionManager;
        }
        if (toSetDependentSessionManager != null) {
            toSetDependentSessionManager.setHttpClient(httpClient);
        }
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            this.init();
        }
        return new HTTPRepositoryConnection(this, this.createHTTPClient());
    }

    public boolean isWritable() throws RepositoryException {
        if (!this.isInitialized()) {
            this.init();
        }
        boolean isWritable = false;
        try (RDF4JProtocolSession client = this.createHTTPClient();){
            String repositoryURL = client.getRepositoryURL();
            try (TupleQueryResult repositoryList = client.getRepositoryList();){
                while (repositoryList.hasNext()) {
                    BindingSet bindingSet = (BindingSet)repositoryList.next();
                    Value uri = bindingSet.getValue("uri");
                    if (uri == null || !uri.stringValue().equals(repositoryURL)) continue;
                    isWritable = Literals.getBooleanValue((Value)bindingSet.getValue("writable"), (boolean)false);
                    break;
                }
            }
        }
        catch (IOException | QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
        return isWritable;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.tupleFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.tupleFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.rdfFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.rdfFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    protected void initializeInternal() throws RepositoryException {
    }

    protected void shutDownInternal() throws RepositoryException {
        try {
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentSessionManager;
            this.dependentSessionManager = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
        finally {
            this.sessionManager = null;
        }
    }

    protected RDF4JProtocolSession createHTTPClient() {
        RDF4JProtocolSession httpClient = this.getHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);
        httpClient.setValueFactory((ValueFactory)SimpleValueFactory.getInstance());
        if (this.repositoryURL != null) {
            httpClient.setRepository(this.repositoryURL);
        }
        if (this.tupleFormat != null) {
            httpClient.setPreferredTupleQueryResultFormat(this.tupleFormat);
        }
        if (this.rdfFormat != null) {
            httpClient.setPreferredRDFFormat(this.rdfFormat);
        }
        if (this.username != null) {
            httpClient.setUsernameAndPassword(this.username, this.password);
        }
        httpClient.setAdditionalHttpHeaders(this.additionalHttpHeaders);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useCompatibleMode() throws RepositoryException {
        Boolean result = this.compatibleMode;
        if (result == null) {
            HTTPRepository hTTPRepository = this;
            synchronized (hTTPRepository) {
                result = this.compatibleMode;
                if (result == null) {
                    result = this.compatibleMode = Boolean.valueOf(this.getServerProtocolVersion() < 7);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getServerProtocolVersion() {
        try (RDF4JProtocolSession client = this.createHTTPClient();){
            String serverProtocolVersion = client.getServerProtocol();
            int n = Integer.parseInt(serverProtocolVersion);
            return n;
        }
        catch (IOException | NumberFormatException e) {
            throw new RepositoryException("could not read protocol version from server: ", (Throwable)e);
        }
    }
}

