/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import com.google.common.base.MoreObjects;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.filters.AccurateRepositoryBloomFilter;
import org.eclipse.rdf4j.repository.filters.RepositoryBloomFilter;

public class EmptyPatternOptimizer
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private final Collection<? extends RepositoryConnection> members;
    private final Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters;

    public EmptyPatternOptimizer(Collection<? extends RepositoryConnection> members) {
        this(members, c -> AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
    }

    public EmptyPatternOptimizer(Collection<? extends RepositoryConnection> members, Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters) {
        this.members = members;
        this.bloomFilters = bloomFilters;
    }

    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        try {
            query.visit((QueryModelVisitor)this);
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void meet(StatementPattern node) throws RepositoryException {
        Resource subj = (Resource)node.getSubjectVar().getValue();
        IRI pred = (IRI)node.getPredicateVar().getValue();
        Value obj = node.getObjectVar().getValue();
        Resource[] ctx = this.getContexts(node.getContextVar());
        for (RepositoryConnection repositoryConnection : this.members) {
            RepositoryBloomFilter bloomFilter = (RepositoryBloomFilter)MoreObjects.firstNonNull((Object)this.bloomFilters.apply((Repository)repositoryConnection.getRepository()), (Object)AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
            if (!bloomFilter.mayHaveStatement(repositoryConnection, subj, pred, obj, ctx)) continue;
            return;
        }
        node.replaceWith((QueryModelNode)new EmptySet());
    }

    private Resource[] getContexts(Var var) {
        Resource[] resourceArray;
        if (var == null || !var.hasValue()) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = (Resource)var.getValue();
        }
        return resourceArray;
    }
}

