/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MinLengthFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class MinLengthConstraintComponent
extends SimpleAbstractConstraintComponent {
    long minLength;

    public MinLengthConstraintComponent(long minLength) {
        this.minLength = minLength;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> exported) {
        model.add(subject, SHACL.MIN_LENGTH, (Value)Values.literal((String)(this.minLength + ""), (IRI)XMLSchema.INTEGER), new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(String varName, boolean negated) {
        if (negated) {
            return "STRLEN(STR(?" + varName + ")) >= " + this.minLength;
        }
        return "STRLEN(STR(?" + varName + ")) < " + this.minLength;
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new MinLengthFilter((PlanNode)parent, this.minLength);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MinLengthConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MinLengthConstraintComponent(this.minLength);
    }
}

