/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnBufferedPlanNode<T extends PlanNode & MultiStreamPlanNode>
implements PushablePlanNode {
    private final Logger logger = LoggerFactory.getLogger(UnBufferedPlanNode.class);
    private final T parent;
    ValidationTuple next;
    private boolean closed;
    private boolean printed;
    String name;
    private ValidationExecutionLogger validationExecutionLogger;

    UnBufferedPlanNode(T parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        this.next = null;
        this.closed = false;
        return new CloseableIteration<ValidationTuple, SailException>(){
            {
                ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).init();
            }

            @Override
            public void close() throws SailException {
                UnBufferedPlanNode.this.closed = true;
                ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return UnBufferedPlanNode.this.next != null;
            }

            private void calculateNext() {
                boolean success;
                while (UnBufferedPlanNode.this.next == null && (success = ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).incrementIterator())) {
                }
            }

            @Override
            public ValidationTuple next() throws SailException {
                this.calculateNext();
                ValidationTuple tuple = UnBufferedPlanNode.this.next;
                if (GlobalValidationExecutionLogging.loggingEnabled) {
                    UnBufferedPlanNode.this.validationExecutionLogger.log(UnBufferedPlanNode.this.depth(), UnBufferedPlanNode.this.parent.getClass().getSimpleName() + ":UnBuffered" + UnBufferedPlanNode.this.name + ".next()", tuple, UnBufferedPlanNode.this.parent, UnBufferedPlanNode.this.getId());
                }
                UnBufferedPlanNode.this.next = null;
                return tuple;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.parent.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void push(ValidationTuple next) {
        this.next = next;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "UnBufferedPlanNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        if (this.validationExecutionLogger == null) {
            this.validationExecutionLogger = validationExecutionLogger;
            this.parent.receiveLogger(validationExecutionLogger);
        }
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return this.parent.producesSorted();
    }
}

