/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.math.BigDecimal;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class MinExclusiveFilter
extends FilterPlanNode {
    private final BigDecimal min;

    public MinExclusiveFilter(PlanNode parent, BigDecimal min) {
        super(parent);
        this.min = min;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value literal = t.getValue();
        if (literal.isLiteral()) {
            BigDecimal bigDecimal = ((Literal)literal).decimalValue();
            return this.min.compareTo(bigDecimal) < 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return "MinLengthFilter{min=" + this.min + '}';
    }
}

