/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class Contains
implements Function {
    @Override
    public String getURI() {
        return FN.CONTAINS.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("CONTAINS requires 2 arguments, got " + args.length);
        }
        Value leftVal = args[0];
        Value rightVal = args[1];
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            Literal leftLit = (Literal)leftVal;
            Literal rightLit = (Literal)rightVal;
            if (leftLit.getLanguage().isPresent()) {
                if (!rightLit.getLanguage().isPresent() || rightLit.getLanguage().equals(leftLit.getLanguage())) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteral.valueOf(leftLexVal.contains(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
            }
            if (QueryEvaluationUtil.isStringLiteral(leftLit)) {
                if (QueryEvaluationUtil.isStringLiteral(rightLit)) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteral.valueOf(leftLexVal.contains(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
            }
            throw new ValueExprEvaluationException("incompatible operands for CONTAINS function");
        }
        throw new ValueExprEvaluationException("CONTAINS function expects literal operands");
    }
}

