/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;

public abstract class NotifyingSailConnectionBase
extends AbstractSailConnection
implements NotifyingSailConnection {
    private List<SailConnectionListener> listeners = new ArrayList<SailConnectionListener>(0);

    public NotifyingSailConnectionBase(AbstractSail sailBase) {
        super(sailBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConnectionListeners() {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            return !this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementAdded(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementAdded(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementRemoved(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementRemoved(st);
            }
        }
    }
}

