/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.repository.util.RDFLoader;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepositoryConnection
implements RepositoryConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repository;
    private volatile ParserConfig parserConfig = new ParserConfig();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private volatile IsolationLevel isolationLevel;

    protected AbstractRepositoryConnection(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.getRepository().getValueFactory();
    }

    @Override
    public void begin(IsolationLevel level) throws RepositoryException {
        this.setIsolationLevel(level);
        this.begin();
    }

    @Override
    public void setIsolationLevel(IsolationLevel level) throws IllegalStateException {
        try {
            if (this.isActive()) {
                throw new IllegalStateException("Transaction isolation level can not be modified while transaction is active");
            }
            this.isolationLevel = level;
        }
        catch (UnknownTransactionStateException e) {
            throw new IllegalStateException("Transaction isolation level can not be modified while transaction state is unknown", (Throwable)((Object)e));
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Transaction isolation level can not be modified due to repository error", (Throwable)((Object)e));
        }
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.isOpen.get();
    }

    @Override
    public void close() throws RepositoryException {
        this.isOpen.set(false);
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareQuery(ql, query, null);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareGraphQuery(ql, query, null);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update) throws MalformedQueryException, RepositoryException {
        return this.prepareUpdate(ql, update, null);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try (RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);){
            boolean bl = stIter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.hasStatement(st.getSubject(), st.getPredicate(), st.getObject(), includeInferred, contexts);
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) == 0L;
    }

    @Override
    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, handler, contexts);
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (this.isActive()) {
            if (autoCommit) {
                this.commit();
            }
        } else if (!autoCommit) {
            this.begin();
        }
    }

    @Override
    @Deprecated
    public boolean isAutoCommit() throws RepositoryException {
        return !this.isActive();
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(file, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)((Object)e.getCause());
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(url, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)((Object)e.getCause());
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(in, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)((Object)e.getCause());
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    protected final boolean startLocalTransaction() throws RepositoryException {
        if (!this.isActive()) {
            this.begin();
            return true;
        }
        return false;
    }

    protected final void conditionalCommit(boolean condition) throws RepositoryException {
        if (condition) {
            this.commit();
        }
    }

    protected final void conditionalRollback(boolean condition) throws RepositoryException {
        if (condition) {
            this.rollback();
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(reader, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)((Object)e.getCause());
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            for (Statement statement : statements) {
                this.addWithoutCommit(statement, contexts);
            }
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        try {
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            boolean localTransaction = this.startLocalTransaction();
            try {
                while (statements.hasNext()) {
                    this.addWithoutCommit((Statement)statements.next(), contexts);
                }
                this.conditionalCommit(localTransaction);
            }
            catch (RepositoryException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
            catch (RuntimeException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
        }
        finally {
            Iterations.closeCloseable(statements);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(st, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.addWithoutCommit(subject, predicate, object, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            for (Statement statement : statements) {
                this.remove(statement, contexts);
            }
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        try {
            boolean localTransaction = this.startLocalTransaction();
            try {
                while (statements.hasNext()) {
                    this.remove((Statement)statements.next(), contexts);
                }
                this.conditionalCommit(localTransaction);
            }
            catch (RepositoryException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
            catch (RuntimeException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
        }
        finally {
            Iterations.closeCloseable(statements);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.removeWithoutCommit(st, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.removeWithoutCommit(subject, predicate, object, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.remove((Resource)null, (IRI)null, (Value)null, contexts);
    }

    protected void addWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.addWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void addWithoutCommit(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    protected void removeWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.removeWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void removeWithoutCommit(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;
}

