/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import java.io.IOException;
import java.text.ParseException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

class FunctionArguments {
    private FunctionArguments() {
    }

    public static double getDouble(Function func, Value v) throws ValueExprEvaluationException {
        if (!(v instanceof Literal)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + v);
        }
        try {
            return ((Literal)v).doubleValue();
        }
        catch (NumberFormatException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }

    public static String getString(Function func, Value v) throws ValueExprEvaluationException {
        Literal l = FunctionArguments.getLiteral(func, v, XSD.STRING);
        return l.stringValue();
    }

    public static Shape getShape(Function func, Value v, SpatialContext context) throws ValueExprEvaluationException {
        Literal wktLiteral = FunctionArguments.getLiteral(func, v, GEO.WKT_LITERAL);
        try {
            ShapeReader reader = context.getFormats().getWktReader();
            return reader.read((Object)wktLiteral.getLabel());
        }
        catch (IOException | ParseException | InvalidShapeException e) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + wktLiteral, e);
        }
    }

    public static Point getPoint(Function func, Value v, SpatialContext geoContext) throws ValueExprEvaluationException {
        Shape p = FunctionArguments.getShape(func, v, geoContext);
        if (!(p instanceof Point)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + " (not a point): " + v);
        }
        return (Point)p;
    }

    public static Literal getLiteral(Function func, Value v, IRI expectedDatatype) throws ValueExprEvaluationException {
        if (!(v instanceof Literal)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + v);
        }
        Literal lit = (Literal)v;
        if (!expectedDatatype.equals((Object)lit.getDatatype())) {
            throw new ValueExprEvaluationException("Invalid datatype " + lit.getDatatype() + " for " + func.getURI() + ": " + v);
        }
        return lit;
    }

    public static IRI getUnits(Function func, Value v) throws ValueExprEvaluationException {
        if (!(v instanceof IRI)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + v);
        }
        IRI unitUri = (IRI)v;
        if (!unitUri.getNamespace().equals("http://www.opengis.net/def/uom/OGC/1.0/")) {
            throw new ValueExprEvaluationException("Invalid unit of measurement URI for " + func.getURI() + ": " + v);
        }
        return unitUri;
    }

    public static double convertFromDegrees(double degs, IRI units) throws ValueExprEvaluationException {
        double v;
        if (GEOF.UOM_DEGREE.equals((Object)units)) {
            v = degs;
        } else if (GEOF.UOM_RADIAN.equals((Object)units)) {
            v = DistanceUtils.toRadians((double)degs);
        } else if (GEOF.UOM_UNITY.equals((Object)units)) {
            v = degs / 180.0;
        } else if (GEOF.UOM_METRE.equals((Object)units)) {
            v = DistanceUtils.degrees2Dist((double)degs, (double)6371.0087714) * 1000.0;
        } else {
            throw new ValueExprEvaluationException("Invalid unit of measurement: " + units);
        }
        return v;
    }

    public static double convertToDegrees(double v, IRI units) throws ValueExprEvaluationException {
        double degs;
        if (GEOF.UOM_DEGREE.equals((Object)units)) {
            degs = v;
        } else if (GEOF.UOM_RADIAN.equals((Object)units)) {
            degs = DistanceUtils.toDegrees((double)v);
        } else if (GEOF.UOM_UNITY.equals((Object)units)) {
            degs = v * 180.0;
        } else if (GEOF.UOM_METRE.equals((Object)units)) {
            degs = DistanceUtils.dist2Degrees((double)(v / 1000.0), (double)6371.0087714);
        } else {
            throw new ValueExprEvaluationException("Invalid unit of measurement: " + units);
        }
        return degs;
    }
}

