/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rdf4j.common.webapp.Message;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

public class MessageHandlerInterceptor
implements HandlerInterceptor {
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mav) {
        HttpSession session = request.getSession();
        if (session != null) {
            Message message = (Message)session.getAttribute("message");
            if (message != null && !mav.getModelMap().containsKey((Object)"message")) {
                mav.addObject("message", (Object)message);
            }
            boolean shouldRemove = true;
            if (mav.hasView() && mav.getView() instanceof RedirectView) {
                shouldRemove = false;
            }
            if (mav.getViewName() != null && mav.getViewName().startsWith("redirect:")) {
                shouldRemove = false;
            }
            if (shouldRemove) {
                session.removeAttribute("message");
            }
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }
}

