/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Locale;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.Help;
import org.eclipse.rdf4j.console.command.ConsoleCommand;

public class PrintHelp
extends ConsoleCommand {
    public static final String USAGE = "Usage:\n";
    private final Map<String, ? extends Help> commands;

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getHelpShort() {
        return "Displays this help message";
    }

    @Override
    public String getHelpLong() {
        return "No additional help available";
    }

    public PrintHelp(ConsoleIO consoleIO, Map<String, ? extends Help> commands) {
        super(consoleIO);
        this.commands = commands;
    }

    @Override
    public void execute(String ... parameters) {
        if (parameters.length < 2) {
            this.printCommandOverview();
            return;
        }
        String target = parameters[1].toLowerCase(Locale.ENGLISH);
        Help cmd = this.commands.get(target);
        if (cmd != null) {
            this.consoleIO.writeln(cmd.getHelpLong());
        } else {
            this.consoleIO.writeln("No additional info available for command " + target);
        }
    }

    private void printCommandOverview() {
        this.consoleIO.writeln("For more information on a specific command, try 'help <command>'.");
        this.consoleIO.writeln("List of all commands:");
        this.commands.forEach((k, v) -> this.consoleIO.writeln(String.format("%-11s %s", k, v.getHelpShort())));
        this.consoleIO.writeln("exit, quit  Exit the console");
    }
}

