/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convert
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Convert.class);

    @Override
    public String getName() {
        return "convert";
    }

    @Override
    public String getHelpShort() {
        return "Converts a file from one RDF format to another";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nconvert <fileFrom> <fileTo>   Converts a file from one RDF format to another\n";
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 3) {
            this.consoleIO.writeln(this.getHelpLong());
            return;
        }
        this.convert(tokens[1], tokens[2]);
    }

    private void convert(String fileFrom, String fileTo) {
        Path pathFrom = Util.getPath(fileFrom);
        if (pathFrom == null) {
            this.consoleIO.writeError("Invalid file name (from) " + fileFrom);
            return;
        }
        if (Files.notExists(pathFrom, new LinkOption[0])) {
            this.consoleIO.writeError("File not found (from) " + fileFrom);
            return;
        }
        Optional<RDFFormat> fmtFrom = Rio.getParserFormatForFileName(fileFrom);
        if (!fmtFrom.isPresent()) {
            this.consoleIO.writeError("No RDF parser for " + fileFrom);
            return;
        }
        Path pathTo = Util.getPath(fileTo);
        if (pathTo == null) {
            this.consoleIO.writeError("Invalid file name (to) " + pathTo);
            return;
        }
        Optional<RDFFormat> fmtTo = Rio.getWriterFormatForFileName(fileTo);
        if (!fmtTo.isPresent()) {
            this.consoleIO.writeError("No RDF writer for " + fileTo);
            return;
        }
        if (Files.exists(pathTo, new LinkOption[0])) {
            try {
                boolean overwrite = this.consoleIO.askProceed("File exists, continue ?", false);
                if (!overwrite) {
                    this.consoleIO.writeln("Conversion aborted");
                    return;
                }
            }
            catch (IOException ioe) {
                this.consoleIO.writeError("I/O error " + ioe.getMessage());
            }
        }
        RDFParser parser = Rio.createParser(fmtFrom.get());
        String baseURI = pathFrom.toUri().toString();
        try (BufferedInputStream r = new BufferedInputStream(Files.newInputStream(pathFrom, new OpenOption[0]));
             BufferedWriter w = Files.newBufferedWriter(pathTo, new OpenOption[0]);){
            RDFWriter writer = Rio.createWriter(fmtTo.get(), w);
            parser.setRDFHandler(writer);
            long startTime = System.nanoTime();
            this.consoleIO.writeln("Converting file ...");
            parser.parse(r, baseURI);
            long diff = (System.nanoTime() - startTime) / 1000000L;
            this.consoleIO.writeln("Data has been written to file (" + diff + " ms)");
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            this.consoleIO.writeError("Failed to convert data: " + e.getMessage());
        }
    }

    public Convert(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }
}

