/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.spin.config.SpinSailSchema;

public class SpinSailConfig
extends AbstractDelegatingSailImplConfig {
    private boolean axiomClosureNeeded = true;

    public SpinSailConfig() {
        super("openrdf:SpinSail");
    }

    public SpinSailConfig(SailImplConfig delegate) {
        super("openrdf:SpinSail", delegate);
        if ("openrdf:ForwardChainingRDFSInferencer".equals(delegate.getType())) {
            this.setAxiomClosureNeeded(false);
        }
    }

    public SpinSailConfig(SailImplConfig delegate, boolean axiomClosureNeeded) {
        super("openrdf:SpinSail", delegate);
        this.setAxiomClosureNeeded(axiomClosureNeeded);
    }

    public boolean isAxiomClosureNeeded() {
        return this.axiomClosureNeeded;
    }

    public void setAxiomClosureNeeded(boolean axiomClosureNeeded) {
        this.axiomClosureNeeded = axiomClosureNeeded;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral(m.filter(implNode, SpinSailSchema.AXIOM_CLOSURE_NEEDED, null, new Resource[0])).ifPresent(lit -> this.setAxiomClosureNeeded(lit.booleanValue()));
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

