/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class SetFilterNode
implements PlanNode {
    private Set<Value> targetNodeList;
    private PlanNode parent;
    private int index;
    private boolean returnValid;
    private boolean printed;

    public SetFilterNode(Set<Value> targetNodeList, PlanNode parent, int index, boolean returnValid) {
        this.targetNodeList = targetNodeList;
        this.parent = parent;
        this.index = index;
        this.returnValid = returnValid;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> iterator;
            Tuple next;
            {
                this.iterator = SetFilterNode.this.parent.iterator();
            }

            private void calulateNext() {
                while (this.next == null && this.iterator.hasNext()) {
                    Tuple temp = (Tuple)this.iterator.next();
                    boolean contains = SetFilterNode.this.targetNodeList.contains(temp.getlist().get(SetFilterNode.this.index));
                    if (SetFilterNode.this.returnValid && contains) {
                        this.next = temp;
                        continue;
                    }
                    if (SetFilterNode.this.returnValid || contains) continue;
                    this.next = temp;
                }
            }

            @Override
            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calulateNext();
                return this.next != null;
            }

            @Override
            public Tuple next() throws SailException {
                this.calulateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    public String toString() {
        return "SetFilterNode{targetNodeList=" + Arrays.toString(this.targetNodeList.toArray()) + ", index=" + this.index + ", returnValid=" + this.returnValid + '}';
    }
}

