/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class BufferedSplitter {
    PlanNode parent;
    private List<Tuple> tuplesBuffer;
    private BufferedSplitter that = this;
    private boolean printed = false;

    public BufferedSplitter(PlanNode planNode) {
        this.parent = planNode;
    }

    private synchronized void init() {
        if (this.tuplesBuffer == null) {
            this.tuplesBuffer = new ArrayList<Tuple>();
            try (CloseableIteration<Tuple, SailException> iterator = this.parent.iterator();){
                while (iterator.hasNext()) {
                    Tuple next = (Tuple)iterator.next();
                    this.tuplesBuffer.add(next);
                }
            }
        }
    }

    public PlanNode getPlanNode() {
        return new PlanNode(){

            @Override
            public CloseableIteration<Tuple, SailException> iterator() {
                BufferedSplitter.this.init();
                final Iterator iterator = BufferedSplitter.this.tuplesBuffer.iterator();
                return new CloseableIteration<Tuple, SailException>(){

                    @Override
                    public void close() throws SailException {
                    }

                    @Override
                    public boolean hasNext() throws SailException {
                        return iterator.hasNext();
                    }

                    @Override
                    public Tuple next() throws SailException {
                        return new Tuple((Tuple)iterator.next());
                    }

                    @Override
                    public void remove() throws SailException {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int depth() {
                return BufferedSplitter.this.parent.depth() + 1;
            }

            @Override
            public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
                if (BufferedSplitter.this.printed) {
                    return;
                }
                BufferedSplitter.this.printed = true;
                stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
                stringBuilder.append(BufferedSplitter.this.parent.getId() + " -> " + this.getId()).append("\n");
                BufferedSplitter.this.parent.getPlanAsGraphvizDot(stringBuilder);
            }

            @Override
            public String getId() {
                return System.identityHashCode(BufferedSplitter.this.that) + "";
            }

            @Override
            public IteratorData getIteratorDataType() {
                return BufferedSplitter.this.parent.getIteratorDataType();
            }

            public String toString() {
                return "BufferedSplitter";
            }
        };
    }
}

