/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;
import org.eclipse.rdf4j.spin.function.ConstructTupleFunction;
import org.eclipse.rdf4j.spin.function.SelectTupleFunction;
import org.eclipse.rdf4j.spin.function.TransientTupleFunction;

public class SpinTupleFunction
extends AbstractSpinFunction
implements TransientTupleFunction {
    private ParsedQuery parsedQuery;
    private final List<Argument> arguments = new ArrayList<Argument>(4);

    public SpinTupleFunction(String uri) {
        super(uri);
    }

    public void setParsedQuery(ParsedQuery query) {
        this.parsedQuery = query;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    public void addArgument(Argument arg) {
        this.arguments.add(arg);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.getURI() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> evaluate(ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        Object iter;
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (this.parsedQuery instanceof ParsedBooleanQuery) {
            ParsedBooleanQuery askQuery = (ParsedBooleanQuery)this.parsedQuery;
            BooleanQuery queryOp = qp.prepare(askQuery);
            SpinTupleFunction.addBindings((Query)queryOp, this.arguments, args);
            BooleanLiteral result = BooleanLiteral.valueOf((boolean)queryOp.evaluate());
            iter = new SingletonIteration(Collections.singletonList(result));
        } else if (this.parsedQuery instanceof ParsedTupleQuery) {
            ParsedTupleQuery selectQuery = (ParsedTupleQuery)this.parsedQuery;
            TupleQuery queryOp = qp.prepare(selectQuery);
            SpinTupleFunction.addBindings((Query)queryOp, this.arguments, args);
            iter = new SelectTupleFunction.TupleQueryResultIteration(queryOp.evaluate());
        } else if (this.parsedQuery instanceof ParsedGraphQuery) {
            ParsedGraphQuery graphQuery = (ParsedGraphQuery)this.parsedQuery;
            GraphQuery queryOp = qp.prepare(graphQuery);
            SpinTupleFunction.addBindings((Query)queryOp, this.arguments, args);
            iter = new ConstructTupleFunction.GraphQueryResultIteration(queryOp.evaluate());
        } else {
            throw new IllegalStateException("Unexpected query: " + this.parsedQuery);
        }
        return iter;
    }

    private static void addBindings(Query query, List<Argument> arguments, Value ... args) {
        for (int i = 0; i < args.length; ++i) {
            Argument argument = arguments.get(i);
            query.setBinding(argument.getPredicate().getLocalName(), args[i]);
        }
    }
}

