/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class LiteralComparatorFilter
extends FilterPlanNode {
    private final Literal compareTo;
    private final Function<Integer, Boolean> function;
    private final boolean numericDatatype;
    private final boolean calendarDatatype;
    private final boolean durationDatatype;
    private final boolean booleanDatatype;
    private final boolean timeDatatype;
    private final boolean dateDatatype;

    public LiteralComparatorFilter(PlanNode parent, Literal compareTo, Function<Integer, Boolean> function) {
        super(parent);
        this.function = function;
        this.compareTo = compareTo;
        IRI datatype = compareTo.getDatatype();
        this.numericDatatype = XMLDatatypeUtil.isNumericDatatype((IRI)datatype);
        this.calendarDatatype = XMLDatatypeUtil.isCalendarDatatype((IRI)datatype);
        this.durationDatatype = XMLDatatypeUtil.isDurationDatatype((IRI)datatype);
        this.booleanDatatype = XMLSchema.BOOLEAN.equals((Object)datatype);
        this.timeDatatype = XMLSchema.TIME.equals((Object)datatype);
        this.dateDatatype = XMLSchema.DATE.equals((Object)datatype);
    }

    @Override
    boolean checkTuple(Tuple t) {
        IRI datatype;
        Value literal = t.line.get(1);
        if (literal instanceof Literal && this.datatypesMatch(datatype = ((Literal)literal).getDatatype())) {
            if (this.dateDatatype && XMLSchema.DATETIME.equals((Object)datatype)) {
                literal = SimpleValueFactory.getInstance().createLiteral(literal.stringValue().split("T")[0], XMLSchema.DATE);
            }
            int compare = new ValueComparator().compare((Value)this.compareTo, literal);
            return this.function.apply(compare);
        }
        return false;
    }

    private boolean datatypesMatch(IRI datatype) {
        return this.numericDatatype && XMLDatatypeUtil.isNumericDatatype((IRI)datatype) || this.calendarDatatype && XMLDatatypeUtil.isCalendarDatatype((IRI)datatype) && (this.timeDatatype || !XMLSchema.TIME.equals((Object)datatype)) || this.durationDatatype && XMLDatatypeUtil.isDurationDatatype((IRI)datatype) || this.booleanDatatype && XMLSchema.BOOLEAN.equals((Object)datatype);
    }

    @Override
    public String toString() {
        return "LiteralComparatorFilter{function=" + this.function + '}';
    }
}

