/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;

public class ShaclProperties {
    Resource clazz;
    Resource or;
    Long minCount;
    Long maxCount;
    Resource datatype;
    Long minLength;
    Long maxLength;
    Resource languageIn;
    Resource nodeKind;
    Literal minExclusive;
    Literal maxExclusive;
    Literal minInclusive;
    Literal maxInclusive;
    String pattern;
    Resource targetClass;
    List<Value> targetNode = new ArrayList<Value>(0);

    public ShaclProperties(Resource propertyShapeId, SailRepositoryConnection connection) {
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(propertyShapeId, null, null, new Resource[0]));){
            stream.forEach(statement -> {
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                switch (predicate) {
                    case "http://www.w3.org/ns/shacl#or": {
                        if (this.or != null) {
                            throw new IllegalStateException("sh:or already populated");
                        }
                        this.or = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#languageIn": {
                        if (this.languageIn != null) {
                            throw new IllegalStateException("sh:languageIn already populated");
                        }
                        this.languageIn = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#nodeKind": {
                        if (this.nodeKind != null) {
                            throw new IllegalStateException("sh:nodeKind already populated");
                        }
                        this.nodeKind = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#datatype": {
                        if (this.datatype != null) {
                            throw new IllegalStateException("sh:datatype already populated");
                        }
                        this.datatype = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minCount": {
                        if (this.minCount != null) {
                            throw new IllegalStateException("sh:minCount aleady populated");
                        }
                        this.minCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxCount": {
                        if (this.maxCount != null) {
                            throw new IllegalStateException("sh:maxCount aleady populated");
                        }
                        this.maxCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minLength": {
                        if (this.minLength != null) {
                            throw new IllegalStateException("sh:minLength aleady populated");
                        }
                        this.minLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxLength": {
                        if (this.maxLength != null) {
                            throw new IllegalStateException("sh:maxLength aleady populated");
                        }
                        this.maxLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minExclusive": {
                        if (this.minExclusive != null) {
                            throw new IllegalStateException("sh:minExclusive aleady populated");
                        }
                        this.minExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxExclusive": {
                        if (this.maxExclusive != null) {
                            throw new IllegalStateException("sh:maxExclusive aleady populated");
                        }
                        this.maxExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minInclusive": {
                        if (this.minInclusive != null) {
                            throw new IllegalStateException("sh:minInclusive aleady populated");
                        }
                        this.minInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxInclusive": {
                        if (this.maxInclusive != null) {
                            throw new IllegalStateException("sh:maxInclusive aleady populated");
                        }
                        this.maxInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#pattern": {
                        if (this.pattern != null) {
                            throw new IllegalStateException("sh:pattern aleady populated");
                        }
                        this.pattern = object.stringValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#class": {
                        if (this.clazz != null) {
                            throw new IllegalStateException("sh:class aleady populated");
                        }
                        this.clazz = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetNode": {
                        this.targetNode.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetClass": {
                        if (this.targetClass != null) {
                            throw new IllegalStateException("sh:targetClass aleady populated");
                        }
                        this.targetClass = (Resource)object;
                    }
                }
            });
        }
    }
}

