/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;

public class XMLDatatypeMathUtil {
    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (XMLDatatypeUtil.isNumericDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype)) {
            return MathUtil.compute(leftLit, rightLit, op);
        }
        if (XMLDatatypeUtil.isDurationDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isDurationDatatype((IRI)rightDatatype)) {
            return XMLDatatypeMathUtil.operationsBetweenDurations(leftLit, rightLit, op);
        }
        if (XMLDatatypeUtil.isDecimalDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isDurationDatatype((IRI)rightDatatype)) {
            return XMLDatatypeMathUtil.operationsBetweenDurationAndDecimal(rightLit, leftLit, op);
        }
        if (XMLDatatypeUtil.isDurationDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isDecimalDatatype((IRI)rightDatatype)) {
            return XMLDatatypeMathUtil.operationsBetweenDurationAndDecimal(leftLit, rightLit, op);
        }
        if (XMLDatatypeUtil.isCalendarDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isDurationDatatype((IRI)rightDatatype)) {
            return XMLDatatypeMathUtil.operationsBetweenCalendarAndDuration(leftLit, rightLit, op);
        }
        if (XMLDatatypeUtil.isDurationDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isCalendarDatatype((IRI)rightDatatype)) {
            return XMLDatatypeMathUtil.operationsBetweenDurationAndCalendar(leftLit, rightLit, op);
        }
        throw new ValueExprEvaluationException("Mathematical operators are not supported on these operands");
    }

    private static Literal operationsBetweenDurations(Literal leftLit, Literal rightLit, MathExpr.MathOp op) {
        Duration left = XMLDatatypeUtil.parseDuration((String)leftLit.getLabel());
        Duration right = XMLDatatypeUtil.parseDuration((String)rightLit.getLabel());
        try {
            switch (op) {
                case PLUS: {
                    return XMLDatatypeMathUtil.buildLiteral(left.add(right));
                }
                case MINUS: {
                    return XMLDatatypeMathUtil.buildLiteral(left.subtract(right));
                }
                case MULTIPLY: {
                    throw new ValueExprEvaluationException("Multiplication is not defined on xsd:duration.");
                }
                case DIVIDE: {
                    throw new ValueExprEvaluationException("Division is not defined on xsd:duration.");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenDurationAndDecimal(Literal durationLit, Literal decimalLit, MathExpr.MathOp op) {
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        try {
            if (op == MathExpr.MathOp.MULTIPLY) {
                return XMLDatatypeMathUtil.buildLiteral(duration.multiply(decimalLit.decimalValue()));
            }
            throw new ValueExprEvaluationException("Only multiplication is defined between xsd:decimal and xsd:duration.");
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenCalendarAndDuration(Literal calendarLit, Literal durationLit, MathExpr.MathOp op) {
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)calendarLit.calendarValue().clone();
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        try {
            switch (op) {
                case PLUS: {
                    calendar.add(duration);
                    return SimpleValueFactory.getInstance().createLiteral(calendar);
                }
                case MINUS: {
                    calendar.add(duration.negate());
                    return SimpleValueFactory.getInstance().createLiteral(calendar);
                }
                case MULTIPLY: {
                    throw new ValueExprEvaluationException("Multiplication is not defined between xsd:duration and calendar values.");
                }
                case DIVIDE: {
                    throw new ValueExprEvaluationException("Division is not defined between xsd:duration and calendar values.");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenDurationAndCalendar(Literal durationLit, Literal calendarLit, MathExpr.MathOp op) {
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)calendarLit.calendarValue().clone();
        try {
            if (op == MathExpr.MathOp.PLUS) {
                calendar.add(duration);
                return SimpleValueFactory.getInstance().createLiteral(calendar);
            }
            throw new ValueExprEvaluationException("Only addition is defined between xsd:duration and calendar datatypes.");
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal buildLiteral(Duration duration) {
        return SimpleValueFactory.getInstance().createLiteral(duration.toString(), XMLDatatypeMathUtil.getDatatypeForDuration(duration));
    }

    private static IRI getDatatypeForDuration(Duration duration) {
        boolean yearSet = duration.isSet(DatatypeConstants.YEARS);
        boolean monthSet = duration.isSet(DatatypeConstants.MONTHS);
        boolean daySet = duration.isSet(DatatypeConstants.DAYS);
        boolean hourSet = duration.isSet(DatatypeConstants.HOURS);
        boolean minuteSet = duration.isSet(DatatypeConstants.MINUTES);
        boolean secondSet = duration.isSet(DatatypeConstants.SECONDS);
        if (!yearSet && !monthSet) {
            return XMLSchema.DAYTIMEDURATION;
        }
        if (!(daySet || hourSet || minuteSet || secondSet)) {
            return XMLSchema.YEARMONTHDURATION;
        }
        return XMLSchema.DURATION;
    }
}

