/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;

public class TupleFunctionEvaluationStrategy
extends StrictEvaluationStrategy {
    private final TupleFunctionRegistry tupleFuncRegistry;

    public TupleFunctionEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver) {
        this(tripleSource, dataset, serviceResolver, 0L);
    }

    public TupleFunctionEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncThreshold) {
        this(tripleSource, dataset, serviceResolver, TupleFunctionRegistry.getInstance(), iterationCacheSyncThreshold);
    }

    public TupleFunctionEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, TupleFunctionRegistry tupleFuncRegistry, long iterationCacheSyncThreshold) {
        super(tripleSource, dataset, serviceResolver, iterationCacheSyncThreshold);
        this.tupleFuncRegistry = tupleFuncRegistry;
    }

    public TupleFunctionEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, TupleFunctionRegistry tupleFunctionRegistry) {
        this(tripleSource, dataset, serviceResolver, tupleFunctionRegistry, 0L);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof TupleFunctionCall) {
            return this.evaluate((TupleFunctionCall)expr, bindings);
        }
        return super.evaluate(expr, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleFunctionCall expr, BindingSet bindings) throws QueryEvaluationException {
        TupleFunction func = (TupleFunction)this.tupleFuncRegistry.get(expr.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown tuple function '" + expr.getURI() + "'"));
        List args = expr.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate((ValueExpr)args.get(i), bindings);
        }
        return TupleFunctionEvaluationStrategy.evaluate(func, expr.getResultVars(), bindings, this.tripleSource.getValueFactory(), argValues);
    }

    public static CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleFunction func, final List<Var> resultVars, final BindingSet bindings, ValueFactory valueFactory, Value ... argValues) throws QueryEvaluationException {
        final CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> iter = func.evaluate(valueFactory, argValues);
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){

            public BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet resultBindings = null;
                block0: while (resultBindings == null && iter.hasNext()) {
                    resultBindings = new QueryBindingSet(bindings);
                    List values = (List)iter.next();
                    if (resultVars.size() != values.size()) {
                        throw new QueryEvaluationException("Incorrect number of result vars: require " + values.size());
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        Value result = (Value)values.get(i);
                        Var resultVar = (Var)resultVars.get(i);
                        Value varValue = resultVar.getValue();
                        String varName = resultVar.getName();
                        Value boundValue = bindings.getValue(varName);
                        if ((varValue == null || result.equals(varValue)) && (boundValue == null || result.equals(boundValue))) {
                            if (boundValue != null) continue;
                            resultBindings.addBinding(varName, result);
                            continue;
                        }
                        resultBindings = null;
                        continue block0;
                    }
                }
                return resultBindings;
            }

            protected void handleClose() throws QueryEvaluationException {
                try {
                    super.handleClose();
                }
                finally {
                    iter.close();
                }
            }
        };
    }
}

