/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.superc.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ctx.superc.ui.wizard.SuperWizardContextPage;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class NewSuperContextWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private SuperWizardContextPage selectContextPage;
    private IContext context;

    public NewSuperContextWizard() {
        this.setWindowTitle("New Super Context Wizard");
    }

    public IContext getContext() {
        return this.context;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.selectContextPage = new SuperWizardContextPage(this.selection);
        this.addPage((IWizardPage)this.selectContextPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            IProject project = this.selectContextPage.getProject();
            ContextType type = this.selectContextPage.getContextType();
            String name = this.selectContextPage.getContextName();
            IPath containerPath = this.selectContextPage.getPathInProject();
            IQ7Folder folder = RcpttCore.create((IProject)project).getFolder(containerPath);
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(this.getShell());
            if (!writeAccessChecker.makeResourceWritable(new IResource[]{folder.getResource()})) {
                return false;
            }
            this.context = folder.createContext(name, ContextTypeManager.getInstance().getTypeById("org.eclipse.rcptt.ctx.super"), true, (IProgressMonitor)new NullProgressMonitor());
            IQ7NamedElement copy = this.context.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                SuperContext superCtx = (SuperContext)copy.getNamedElement();
                superCtx.setChildType(type.getId());
                if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{copy})) {
                    return false;
                }
                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                copy.discardWorkingCopy();
            }
            IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)this.context.getResource()));
            return true;
        }
        catch (Exception e) {
            Q7UIPlugin.log((Throwable)e);
            return false;
        }
    }

    public IProject getProject() {
        return this.selectContextPage.getProject();
    }
}

