/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.IContextMaker;
import org.eclipse.rcptt.core.scenario.Context;

public class ContextType {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_CLASS = "eclass";
    private static final String ATTR_PACKAGE = "epackage-uri";
    private static final String ATTR_CAN_CREATE = "canCreate";
    private static final String ATTR_PRIORITY = "priority";
    private final String id;
    private final String name;
    private final String description;
    private final EClass eClass;
    private final String contributorId;
    private boolean canCreate;
    private final int priority;

    public ContextType(IConfigurationElement element) throws CoreException {
        int parsed;
        this.id = this.getVal(element, ATTR_ID);
        this.name = this.getVal(element, ATTR_NAME);
        this.description = this.getVal(element, ATTR_DESCRIPTION);
        this.contributorId = element.getContributor().getName();
        this.canCreate = Boolean.TRUE.toString().equals(this.getVal(element, ATTR_CAN_CREATE));
        try {
            parsed = Integer.parseInt(this.getVal(element, ATTR_PRIORITY));
        }
        catch (NumberFormatException e) {
            parsed = 10;
        }
        this.priority = parsed;
        String packageUri = this.getVal(element, ATTR_PACKAGE);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        if (ePackage == null) {
            throw new IllegalArgumentException("Invalid package uri for '" + this.id + "' context type: " + packageUri);
        }
        String className = this.getVal(element, ATTR_CLASS);
        EClassifier classifier = ePackage.getEClassifier(className);
        if (!(classifier instanceof EClass)) {
            throw new IllegalArgumentException("Invalid class name for '" + this.id + "' context type: " + className);
        }
        this.eClass = (EClass)classifier;
    }

    public String getContributorId() {
        return this.contributorId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public boolean canCreate() {
        return this.canCreate;
    }

    public int getPriority() {
        return this.priority;
    }

    public Context create(Resource resource, String name) {
        return this.getMaker().create(resource, this, name);
    }

    public IStatus validate(Context context) {
        return this.getMaker().validate(context);
    }

    public IContextMaker getMaker() {
        return ContextTypeManager.getInstance().getMaker(this.getId());
    }

    private String getVal(IConfigurationElement element, String attr) {
        String val = element.getAttribute(attr);
        if (val == null || val.length() == 0) {
            throw new IllegalArgumentException("Context type " + attr + " can't be empty");
        }
        return val;
    }

    public boolean canMake() {
        return this.getMaker().canMake();
    }
}

