/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.ui.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.ui.rap.PlatformUIPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;

public class SaveScreenshotService
implements ICommandService {
    private static Map<String, Integer> exts = new HashMap<String, Integer>();

    static {
        exts.put(".png", 5);
        exts.put(".jpg", 4);
        exts.put(".bmp", 0);
    }

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        return Status.OK_STATUS;
    }

    private static IStatus writeData(File file, byte[] data) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(data);
            out.close();
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            return PlatformUIPlugin.createError(e, "Error saving screenshot: %s", e.getMessage());
        }
    }

    private static int formatFromExt(String ext, int def) {
        return exts.containsKey(ext = ext.toLowerCase()) ? exts.get(ext) : def;
    }

    private static String ext(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(lastDot);
    }

    private static boolean isValidInput(Object input) {
        return input instanceof Control || input instanceof TreeItem || input instanceof TableItem || input instanceof ToolItem;
    }

    private static Rectangle getScreenBounds(Object input) {
        if (input instanceof Shell) {
            return ((Shell)input).getBounds();
        }
        if (input instanceof Control) {
            Rectangle bounds = SaveScreenshotService.getBounds(input);
            return SaveScreenshotService.shift(new Rectangle(0, 0, bounds.width, bounds.height), ((Control)input).toDisplay(0, 0));
        }
        Object parent = SaveScreenshotService.getParent(input);
        Point location = parent == null ? new Point(0, 0) : SaveScreenshotService.topLeft(SaveScreenshotService.getScreenBounds(parent));
        return SaveScreenshotService.shift(SaveScreenshotService.getBounds(input), location);
    }

    private static Rectangle getBounds(Object input) {
        if (input instanceof Control) {
            ((Control)input).getLocation();
            return ((Control)input).getBounds();
        }
        if (input instanceof TreeItem) {
            return ((TreeItem)input).getBounds();
        }
        if (input instanceof TableItem) {
            return ((TableItem)input).getBounds();
        }
        if (input instanceof ToolItem) {
            return ((ToolItem)input).getBounds();
        }
        throw new IllegalArgumentException(input.getClass().toString());
    }

    private static Point topLeft(Rectangle bounds) {
        return new Point(bounds.x, bounds.y);
    }

    private static Object getParent(Object input) {
        if (input instanceof Shell) {
            return null;
        }
        if (input instanceof Control) {
            return ((Control)input).getParent();
        }
        if (input instanceof TreeItem) {
            return ((TreeItem)input).getParent();
        }
        if (input instanceof TableItem) {
            return ((TableItem)input).getParent();
        }
        if (input instanceof ToolItem) {
            return ((ToolItem)input).getParent();
        }
        throw new IllegalArgumentException(input.getClass().toString());
    }

    public static Shell getShell(Object input) {
        if (input instanceof Control) {
            return ((Control)input).getShell();
        }
        if (input instanceof TreeItem) {
            return ((TreeItem)input).getParent().getShell();
        }
        if (input instanceof TableItem) {
            return ((TableItem)input).getParent().getShell();
        }
        if (input instanceof ToolItem) {
            return ((ToolItem)input).getParent().getShell();
        }
        throw new IllegalArgumentException(input.getClass().toString());
    }

    private static Rectangle shift(Rectangle rect, Point distance) {
        return new Rectangle(rect.x + distance.x, rect.y + distance.y, rect.width, rect.height);
    }
}

