/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public final class RefactoringAvailabilityTesterCore {
    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaModelException {
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(member)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaModelException {
        boolean is18OrHigher;
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (!(type != 9 || !declaring.isInterface() || (is18OrHigher = JavaModelUtil.is1d8OrHigher(member.getJavaProject())) && Flags.isStatic((int)member.getFlags()))) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic(member);
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (!type.equals(member.getDeclaringType())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }

    public static boolean isInlineTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isInlineConstantAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isInlineMethodAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (!method.isBinary()) {
            return true;
        }
        if (method.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable((ISourceRange)method.getNameRange());
    }

    public static ASTNode getInlineableMethodNode(ITypeRoot typeRoot, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = RefactoringAvailabilityTesterCore.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)typeRoot), (IJavaElement)typeRoot);
        }
        catch (JavaModelException javaModelException) {}
        if (node != null) {
            return node;
        }
        return RefactoringAvailabilityTesterCore.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length), (IJavaElement)typeRoot);
    }

    private static ASTNode getInlineableMethodNode(ASTNode node, IJavaElement unit) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 42: {
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == MethodDeclaration.NAME_PROPERTY) {
                    return node.getParent();
                }
                if (locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SuperMethodInvocation.NAME_PROPERTY) {
                    return unit instanceof ICompilationUnit ? node.getParent() : null;
                }
                return null;
            }
            case 21: {
                node = ((ExpressionStatement)node).getExpression();
            }
        }
        switch (node.getNodeType()) {
            case 31: {
                return node;
            }
            case 17: 
            case 32: 
            case 48: {
                return unit instanceof ICompilationUnit ? node : null;
            }
        }
        return null;
    }

    private RefactoringAvailabilityTesterCore() {
    }
}

