/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.canvas.rap;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IBasicSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.SWTEventRecorder;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class CanvasRecordingProcessor
implements IRecordingProcessor,
IBasicSWTEventListener {
    private TeslaRecorder recorder;
    private SWTEventRecorder eventRecorder;
    private Set<Widget> workingWidgets = new HashSet<Widget>();

    public CanvasRecordingProcessor() {
        SWTEventManager.addListener((IAbstractSWTEventListener)this);
    }

    public int getInitLevel() {
        return 1000;
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    public TeslaRecorder getRecorder() {
        return this.recorder;
    }

    private synchronized SWTEventRecorder getSWTEventRecorder() {
        if (this.eventRecorder == null) {
            this.eventRecorder = (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.eventRecorder;
    }

    public void recordEvent(Widget widget, int type, Event event) {
        FindResult canvas;
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        SWTEventRecorder swtRecorder = this.getSWTEventRecorder();
        if (swtRecorder == null) {
            return;
        }
        if (swtRecorder.isIgnored(widget)) {
            return;
        }
        if (swtRecorder.isNotNative(widget)) {
            return;
        }
        if (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use")) {
            return;
        }
        if (widget instanceof Canvas && swtRecorder.isCanvas(widget, type) && this.workingWidgets.contains(widget) && (canvas = swtRecorder.getLocator().findElement(widget, false, false, false)) != null) {
            this.processCavas(widget, type, event, canvas);
        }
    }

    private void processCavas(Widget widget, int type, Event event, FindResult canvas) {
        if (canvas != null) {
            ControlUIElement canvasCtrl = new ControlUIElement(canvas.element, (UIPlayer)this.getRecorder());
            Canvas cv = (Canvas)widget;
            Rectangle bounds = cv.getBounds();
            switch (type) {
                case 3: {
                    canvasCtrl.executeMouseCommand(event.x, event.y, event.button, MouseCommandKind.DOWN, bounds.width, bounds.height, event.stateMask);
                    break;
                }
                case 4: {
                    canvasCtrl.executeMouseCommand(event.x, event.y, event.button, MouseCommandKind.UP, bounds.width, bounds.height, event.stateMask);
                    break;
                }
                case 8: {
                    canvasCtrl.executeMouseCommand(event.x, event.y, event.button, MouseCommandKind.DOUBLE_CLICK, bounds.width, bounds.height, event.stateMask);
                }
            }
        }
    }

    public void clear() {
        this.workingWidgets.clear();
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper<?> getHelper() {
        return null;
    }

    public boolean isExclusiveEventHandle(Widget widget, int type, Event event) {
        return false;
    }
}

