/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.ServerChannel;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    protected final AtomicBoolean exitStatusSent = new AtomicBoolean(false);

    protected AbstractServerChannel(CloseableExecutorService executor) {
        super("", false, Collections.emptyList(), executor);
    }

    protected AbstractServerChannel(String discriminator, Collection<? extends RequestHandler<Channel>> handlers, CloseableExecutorService executor) {
        super(discriminator, false, handlers, executor);
    }

    @Override
    public OpenFuture open(int recipient, long rwSize, long packetSize, Buffer buffer) {
        this.setRecipient(recipient);
        Session s = this.getSession();
        FactoryManager manager = Objects.requireNonNull(s.getFactoryManager(), "No factory manager");
        Window wRemote = this.getRemoteWindow();
        wRemote.init(rwSize, packetSize, manager);
        this.configureWindow();
        return this.doInit(buffer);
    }

    @Override
    public void handleOpenSuccess(int recipient, long rwSize, long packetSize, Buffer buffer) throws IOException {
        throw new UnsupportedOperationException("handleOpenSuccess(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    @Override
    public void handleOpenFailure(Buffer buffer) {
        throw new UnsupportedOperationException("handleOpenFailure() N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this, this);
        String changeEvent = "doInit";
        try {
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e = ExceptionUtils.peelException(t);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
        return f;
    }

    protected void sendExitStatus(int v) throws IOException {
        if (this.exitStatusSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendExitStatus({}) exit-status={} - already sent", (Object)this, (Object)v);
            }
            this.notifyStateChanged("exit-status");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendExitStatus({}) SSH_MSG_CHANNEL_REQUEST exit-status={}", (Object)this, (Object)v);
        }
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putInt(this.getRecipient());
        buffer.putString("exit-status");
        buffer.putBoolean(false);
        buffer.putInt(v);
        this.writePacket(buffer);
        this.notifyStateChanged("exit-status");
    }
}

