/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.emf;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModelFactory;
import org.eclipse.rcptt.core.persistence.emf.PersistenceEMFModel;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;

public class PersistenceEMFModelFactory
implements IPersistenceModelFactory {
    @Override
    public IPersistenceModel createModel(Resource resource) {
        return new PersistenceEMFModel(resource);
    }

    @Override
    public boolean isSupported(InputStream contents) {
        try {
            byte[] content = FileUtil.getStreamContent((InputStream)new BufferedInputStream(contents), (int)100);
            String s = new String(content);
            if (s.contains("<?xml")) {
                return true;
            }
        }
        catch (Throwable e) {
            RcpttPlugin.log(e);
        }
        finally {
            FileUtil.safeClose((Closeable)contents);
        }
        return false;
    }

    @Override
    public boolean isSupported(File file) {
        return false;
    }
}

