/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.type;

import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.util.TypeVisitor;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class PrimitiveTypeImpl
implements PrimitiveType,
EclipseMirrorType {
    private final ITypeBinding _binding;

    public PrimitiveTypeImpl(ITypeBinding binding) {
        assert (binding != null);
        this._binding = binding;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visitPrimitiveType(this);
    }

    @Override
    public PrimitiveType.Kind getKind() {
        String name = this.getTypeBinding().getName();
        if ("int".equals(name)) {
            return PrimitiveType.Kind.INT;
        }
        if ("byte".equals(name)) {
            return PrimitiveType.Kind.BYTE;
        }
        if ("short".equals(name)) {
            return PrimitiveType.Kind.SHORT;
        }
        if ("char".equals(name)) {
            return PrimitiveType.Kind.CHAR;
        }
        if ("long".equals(name)) {
            return PrimitiveType.Kind.LONG;
        }
        if ("float".equals(name)) {
            return PrimitiveType.Kind.FLOAT;
        }
        if ("double".equals(name)) {
            return PrimitiveType.Kind.DOUBLE;
        }
        if ("boolean".equals(name)) {
            return PrimitiveType.Kind.BOOLEAN;
        }
        throw new IllegalStateException("unrecognized primitive type " + this._binding);
    }

    @Override
    public String toString() {
        return this._binding.getName();
    }

    @Override
    public ITypeBinding getTypeBinding() {
        return this._binding;
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_PRIMITIVE;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return this._binding.isEqualTo((IBinding)((PrimitiveTypeImpl)obj)._binding);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public BaseProcessorEnv getEnvironment() {
        return null;
    }

    @Override
    public boolean isAssignmentCompatible(EclipseMirrorType left) {
        return this.getTypeBinding().isAssignmentCompatible(left.getTypeBinding());
    }

    @Override
    public boolean isSubTypeCompatible(EclipseMirrorType type) {
        return this.getTypeBinding().isSubTypeCompatible(type.getTypeBinding());
    }
}

