/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;

public abstract class AbstractDeleteVerificationReferenceChange
extends Change {
    private IQ7Element element;
    private final IVerification verification;
    private String verificationID;

    protected AbstractDeleteVerificationReferenceChange(IQ7Element element, IVerification verification, String verificationID) {
        this.element = element;
        this.verification = verification;
        this.verificationID = verificationID;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return this.element.getResource();
    }

    protected final IQ7Element getElement() {
        return this.element;
    }

    protected final IVerification getVerification() {
        return this.verification;
    }

    protected final String getVerificationId() {
        return this.verificationID;
    }

    protected boolean isValid() throws ModelException {
        if (this.element == null || this.verification == null) {
            return false;
        }
        if (this.getVerificationId() == null || this.getVerificationId().length() == 0) {
            return false;
        }
        return this.element instanceof ITestCase || this.element instanceof IQ7ProjectMetadata;
    }

    protected final List<String> getVerificationReferences(IQ7NamedElement copy) throws ModelException {
        if (copy instanceof ITestCase) {
            return new ArrayList<String>(Arrays.asList(((ITestCase)copy).getVerifications()));
        }
        if (copy instanceof IQ7ProjectMetadata) {
            return new ArrayList<String>(Arrays.asList(((IQ7ProjectMetadata)copy).getVerifications()));
        }
        throw new IllegalArgumentException();
    }
}

