/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefsNode;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.LocalNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteTrackingNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.TagsNode;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractBranchSelectionDialog
extends TitleAreaDialog {
    protected final Repository repo;
    protected TreeViewer branchTree;
    private String selectedBranch;
    private final String refToMark;
    private final RepositoryTreeNode<Repository> localBranches;
    private final RepositoryTreeNode<Repository> remoteBranches;
    private final RepositoryTreeNode<Repository> tags;
    private final RepositoryTreeNode<Repository> references;
    protected static final int SHOW_LOCAL_BRANCHES = 2;
    protected static final int SHOW_REMOTE_BRANCHES = 4;
    protected static final int SHOW_TAGS = 8;
    protected static final int SHOW_REFERENCES = 16;
    protected static final int SELECT_CURRENT_REF = 32;
    protected static final int EXPAND_LOCAL_BRANCHES_NODE = 64;
    protected static final int EXPAND_REMOTE_BRANCHES_NODE = 128;
    protected static final int ALLOW_MULTISELECTION = 256;
    private final int settings;

    protected static String getMergeTarget(Repository repo) {
        String branch;
        try {
            branch = repo.getBranch();
        }
        catch (IOException e) {
            return null;
        }
        if (branch == null) {
            return null;
        }
        String merge = repo.getConfig().getString("branch", branch, "merge");
        if (merge == null) {
            return null;
        }
        String remote = repo.getConfig().getString("branch", branch, "remote");
        if (remote == null) {
            return null;
        }
        if (".".equals(remote)) {
            return merge;
        }
        return "refs/remotes/" + remote + "/" + Repository.shortenRefName((String)merge);
    }

    protected static int getSelectSetting(Repository repo) {
        return AbstractBranchSelectionDialog.getMergeTarget(repo) != null ? 32 : 0;
    }

    public AbstractBranchSelectionDialog(Shell parentShell, Repository repository, int settings) {
        this(parentShell, repository, null, settings);
        this.setHelpAvailable(false);
    }

    public AbstractBranchSelectionDialog(Shell parentShell, Repository repository, String refToMark, int settings) {
        super(parentShell);
        this.repo = repository;
        this.settings = settings;
        this.localBranches = new LocalNode(null, this.repo);
        this.remoteBranches = new RemoteTrackingNode(null, this.repo);
        this.tags = new TagsNode(null, this.repo);
        this.references = new AdditionalRefsNode(null, this.repo);
        this.refToMark = refToMark;
        this.setHelpAvailable(false);
    }

    protected abstract void refNameSelected(String var1);

    protected abstract String getTitle();

    protected abstract String getMessageText();

    protected String getWindowTitle() {
        return this.getTitle();
    }

    protected final Composite createDialogArea(Composite base) {
        Composite parent = (Composite)super.createDialogArea(base);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        int selectionModel = -1;
        selectionModel = (this.settings & 0x100) != 0 ? 2 : 4;
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredTree tree = new FilteredTree(composite, selectionModel | 0x800, filter, true);
        this.branchTree = tree.getViewer();
        this.branchTree.setUseHashlookup(true);
        this.branchTree.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider());
        this.branchTree.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.branchTree);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 300).applyTo((Control)tree);
        this.branchTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String refName = AbstractBranchSelectionDialog.this.refNameFromDialog();
                AbstractBranchSelectionDialog.this.refNameSelected(refName);
            }
        });
        this.branchTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositoryTreeNode node = (RepositoryTreeNode)((IStructuredSelection)AbstractBranchSelectionDialog.this.branchTree.getSelection()).getFirstElement();
                if (node == null) {
                    return;
                }
                RepositoryTreeNodeType type = node.getType();
                if (type != RepositoryTreeNodeType.REF && type != RepositoryTreeNodeType.TAG && type != RepositoryTreeNodeType.ADDITIONALREF) {
                    AbstractBranchSelectionDialog.this.branchTree.setExpandedState((Object)node, !AbstractBranchSelectionDialog.this.branchTree.getExpandedState((Object)node));
                } else if (AbstractBranchSelectionDialog.this.isOkButtonEnabled()) {
                    AbstractBranchSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        this.branchTree.setComparator(new ViewerComparator(CommonUtils.STRING_ASCENDING_COMPARATOR));
        this.createCustomArea(composite);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessageText());
        this.getShell().setText(this.getWindowTitle());
        AbstractBranchSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void create() {
        super.create();
        this.setOkButtonEnabled(false);
        ArrayList<RepositoryTreeNode<Repository>> roots = new ArrayList<RepositoryTreeNode<Repository>>();
        if ((this.settings & 2) != 0) {
            roots.add(this.localBranches);
        }
        if ((this.settings & 4) != 0) {
            roots.add(this.remoteBranches);
        }
        if ((this.settings & 8) != 0) {
            roots.add(this.tags);
        }
        if ((this.settings & 0x10) != 0) {
            roots.add(this.references);
        }
        this.branchTree.setInput(roots);
        try {
            if ((this.settings & 0x20) != 0) {
                if (this.refToMark != null) {
                    this.markRef(this.refToMark);
                } else {
                    String fullBranch = this.repo.getFullBranch();
                    this.markRef(fullBranch);
                }
            }
            if ((this.settings & 0x40) != 0) {
                this.branchTree.expandToLevel(this.localBranches, 1);
            }
            if ((this.settings & 0x80) != 0) {
                this.branchTree.expandToLevel(this.remoteBranches, 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setOkButtonEnabled(boolean enabled) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
    }

    protected boolean isOkButtonEnabled() {
        return this.getButton(0) != null && this.getButton(0).isEnabled();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean markRef(String refName) {
        void var2_12;
        block13: {
            if (refName == null) {
                return false;
            }
            try {
                if (refName.startsWith("refs/heads/")) {
                    Ref ref = this.repo.exactRef(refName);
                    if (ref == null) {
                        return false;
                    }
                    RefNode refNode = this.createRefNode(this.localBranches, this.repo, ref);
                    break block13;
                }
                if (refName.startsWith("refs/remotes/")) {
                    Ref ref = this.repo.exactRef(refName);
                    if (ref == null) {
                        return false;
                    }
                    RefNode refNode = this.createRefNode(this.remoteBranches, this.repo, ref);
                    break block13;
                }
                if ("HEAD".equals(refName)) {
                    Ref ref = this.repo.exactRef(refName);
                    if (ref == null) {
                        return false;
                    }
                    AdditionalRefNode additionalRefNode = new AdditionalRefNode(this.references, this.repo, ref);
                    break block13;
                }
                String mappedRef = Activator.getDefault().getRepositoryUtil().mapCommitToRef(this.repo, refName, false);
                if (mappedRef != null && mappedRef.startsWith("refs/remotes/")) {
                    Ref ref = this.repo.exactRef(mappedRef);
                    if (ref == null) {
                        return false;
                    }
                    RefNode refNode = this.createRefNode(this.remoteBranches, this.repo, ref);
                    break block13;
                }
                if (mappedRef != null && mappedRef.startsWith("refs/tags/")) {
                    Ref ref = this.repo.exactRef(mappedRef);
                    if (ref == null) {
                        return false;
                    }
                    TagNode tagNode = new TagNode(this.tags, this.repo, ref);
                    break block13;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        this.branchTree.setSelection((ISelection)new StructuredSelection((Object)var2_12), true);
        return true;
    }

    private RefNode createRefNode(RepositoryTreeNode<?> root, Repository repository, Ref ref) {
        IContentProvider cp = this.branchTree.getContentProvider();
        if (cp instanceof RepositoriesViewContentProvider && ((RepositoriesViewContentProvider)cp).isHierarchical()) {
            String fullName = ref.getName();
            int i = 0;
            if (fullName.startsWith("refs/heads/")) {
                i = "refs/heads/".length();
            } else if (fullName.startsWith("refs/remotes/")) {
                i = "refs/remotes/".length();
            }
            BranchHierarchyNode top = root;
            int l = fullName.length();
            while (i < l) {
                int j = fullName.indexOf(47, i);
                if (j <= i) break;
                top = new BranchHierarchyNode(top, repository, (IPath)new Path(fullName.substring(0, j)));
                i = j + 1;
            }
            return new RefNode(top, repository, ref);
        }
        return new RefNode(root, repository, ref);
    }

    public String getRefName() {
        return this.selectedBranch;
    }

    protected void okPressed() {
        this.selectedBranch = this.refNameFromDialog();
        super.okPressed();
    }

    protected String refNameFromDialog() {
        IStructuredSelection sel = (IStructuredSelection)this.branchTree.getSelection();
        if (sel.size() != 1) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
        if (node.getType() == RepositoryTreeNodeType.REF || node.getType() == RepositoryTreeNodeType.TAG || node.getType() == RepositoryTreeNodeType.ADDITIONALREF) {
            return ((Ref)node.getObject()).getName();
        }
        return null;
    }

    protected Ref refFromDialog() {
        IStructuredSelection sel = (IStructuredSelection)this.branchTree.getSelection();
        if (sel.size() != 1) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
        if (node.getType() == RepositoryTreeNodeType.REF || node.getType() == RepositoryTreeNodeType.TAG) {
            return (Ref)node.getObject();
        }
        return null;
    }

    protected void createCustomArea(Composite parent) {
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected String getCurrentBranch() {
        try {
            return this.repo.getBranch();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass());
    }
}

