/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;

class GraphProcessor<T> {
    private final ComputeProjectOrder.Digraph<T> graph;
    private final Set<T> toProcess;
    private final Set<T> processing;
    private final Set<T> processed;
    private final ComputeProjectOrder.VertexOrder<T> sequentialOrder;
    private final JobGroup buildJobGroup;
    final BiConsumer<T, GraphProcessor<T>> processor;

    GraphProcessor(ComputeProjectOrder.Digraph<T> graph1, Class<T> clazz, BiConsumer<T, GraphProcessor<T>> processor, JobGroup buildJobGroup) {
        this.graph = graph1;
        this.processor = processor;
        this.buildJobGroup = buildJobGroup;
        this.toProcess = new HashSet(this.graph.vertexMap.keySet());
        this.processing = new HashSet<T>();
        this.processed = new HashSet<T>();
        this.sequentialOrder = ComputeProjectOrder.computeVertexOrder(this.graph, clazz);
    }

    private boolean complete() {
        return this.processed.size() == this.graph.vertexList.size();
    }

    private boolean allTriggered() {
        return this.toProcess.isEmpty();
    }

    private void markProcessing(T item) {
        if (!this.toProcess.remove(item)) {
            throw new IllegalArgumentException();
        }
        this.processing.add(item);
    }

    void markProcessed(T item) {
        if (!this.processing.remove(item)) {
            throw new IllegalArgumentException();
        }
        this.processed.add(item);
    }

    private Set<T> computeReadyVertexes() {
        HashSet<T> res = new HashSet<T>(this.toProcess);
        for (T item : this.toProcess) {
            for (ComputeProjectOrder.Digraph.Edge edge : this.graph.getEdges()) {
                if (edge.to != item || this.processed.contains(edge.from)) continue;
                res.remove(item);
            }
        }
        if (res.isEmpty() && !this.isProcessing()) {
            T[] TArray = this.sequentialOrder.vertexes;
            int n = this.sequentialOrder.vertexes.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = TArray[n2];
                if (!this.isProcessed(id)) {
                    return Collections.singleton(id);
                }
                ++n2;
            }
        }
        return res;
    }

    private boolean isProcessing() {
        return !this.processing.isEmpty();
    }

    private boolean isProcessed(T item) {
        return this.processed.contains(item);
    }

    public T[] getSequentialOrder() {
        return this.sequentialOrder.vertexes;
    }

    public synchronized void processGraphWithParallelJobs() {
        if (!this.complete() && !this.allTriggered()) {
            Set<Object> readyToBuild = this.computeReadyVertexes();
            readyToBuild.forEach(item -> this.triggerJob(item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerJob(final T item) {
        GraphProcessor graphProcessor = this;
        synchronized (graphProcessor) {
            this.markProcessing(item);
        }
        Job buildJob = new Job(item.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                GraphProcessor.this.processor.accept(item, GraphProcessor.this);
                GraphProcessor graphProcessor = GraphProcessor.this;
                synchronized (graphProcessor) {
                    GraphProcessor.this.markProcessed(item);
                    GraphProcessor.this.processGraphWithParallelJobs();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || family == GraphProcessor.this;
            }
        };
        buildJob.setJobGroup(this.buildJobGroup);
        buildJob.schedule();
    }
}

