/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.internal.EclFileResolver;
import org.eclipse.rcptt.ecl.filesystem.internal.ResourceFile;

public class ResourceFileResolver
implements EclFileResolver {
    public ResourceFileResolver() {
        ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public EclFile resolve(URI uri) throws IOException {
        IPath path = ResourceFileResolver.toPath(uri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (scheme.equals("workspace")) {
            return new ResourceFile(path);
        }
        return null;
    }

    private static IPath toPath(URI uri) {
        String path = uri.getPath().substring(1);
        if (path == null) {
            throw new NullPointerException("Bad URI: " + uri);
        }
        return Path.fromPortableString((String)path);
    }
}

