/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import org.eclipse.rcptt.expandbar.runtime.internal.ItemLocation;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollectingSession;
import org.eclipse.rcptt.tesla.internal.ui.player.IChildrenCollectingExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public class ExpandBarPlayerExtension
extends AbstractSWTUIPlayerExtension {
    public GenericElementKind getKind(Object w) {
        return w instanceof ExpandBar ? new GenericElementKind("org.eclipse.swt.widgets.ExpandBar") : (w instanceof ExpandItem ? new GenericElementKind(ElementKind.Item) : super.getKind(w));
    }

    public SWTUIElement select(SWTUIPlayer p, PlayerSelectionFilter f) {
        if (f.kind.is("org.eclipse.swt.widgets.ExpandBar")) {
            return p.selectWidget(f.withoutPattern(), new Class[]{ExpandBar.class});
        }
        if (f.kind.is(ElementKind.Item)) {
            Widget parent = f.parent.unwrap();
            if (!(parent instanceof ExpandBar)) {
                return null;
            }
            ExpandBar bar = (ExpandBar)parent;
            ExpandItem result = ItemLocation.fromSelectionFilter(f).findMatch(bar);
            return result == null ? null : p.wrap((Object)result);
        }
        return null;
    }

    public Widget getIndirectParent(Widget current) {
        if (current instanceof ExpandItem) {
            return ((ExpandItem)current).getParent();
        }
        if (!(current instanceof Composite)) {
            return null;
        }
        Composite currentComposite = (Composite)current;
        Composite parent = currentComposite.getParent();
        if (!(parent instanceof ExpandBar)) {
            return null;
        }
        ExpandBar expandBar = (ExpandBar)parent;
        ExpandItem[] expandItemArray = expandBar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandItem item = expandItemArray[n2];
            if (item.getControl() == currentComposite) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public IChildrenCollectingExtension getChildrenCollectingExtension(final ChildrenCollectingSession s) {
        return new IChildrenCollectingExtension(){

            public void collect() {
                if (s.w == null) {
                    return;
                }
                Widget widget = s.w.unwrap();
                if (!(widget instanceof ExpandItem)) {
                    return;
                }
                Control content = ((ExpandItem)widget).getControl();
                SWTUIElement contentElement = s.player.wrap((Object)content);
                s.addItem(contentElement);
                if (content instanceof Composite && s.goIntoComposites) {
                    SWTUIElement[] sWTUIElementArray = s.collector.collectFor(contentElement, s.ignores, s.goIntoComposites, s.classes);
                    int n = sWTUIElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SWTUIElement element = sWTUIElementArray[n2];
                        s.addItem(element);
                        ++n2;
                    }
                }
            }
        };
    }
}

