/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public class ApiJavadocTag
implements IApiJavadocTag {
    private String fId = null;
    private String fName = null;
    private HashMap<Integer, String> fTagItems = null;
    private static String EMPTY_STRING = "";
    private int fRModifier = 0;
    private String fTaglabel = null;

    public ApiJavadocTag(String id, String name, int rmodifier) {
        Assert.isNotNull((Object)id);
        this.fId = id;
        Assert.isNotNull((Object)name);
        this.fName = name;
        this.fRModifier = rmodifier;
    }

    public String getTagId() {
        return this.fId;
    }

    @Override
    public int getRestrictionModifier() {
        return this.fRModifier;
    }

    @Override
    public void setApplicableTo(int type, int member, String comment) {
        if (this.fTagItems == null) {
            this.fTagItems = new HashMap(6);
        }
        this.fTagItems.put(this.getTagKey(type, member), comment);
    }

    public String getTagComment(int type, int member) {
        if (this.fTagItems == null) {
            return EMPTY_STRING;
        }
        String obj = this.fTagItems.get(this.getTagKey(type, member));
        return obj == null ? EMPTY_STRING : obj;
    }

    @Override
    public String getTagName() {
        if (this.fTaglabel == null) {
            StringBuffer tag = new StringBuffer();
            tag.append("@");
            tag.append(this.fName);
            this.fTaglabel = tag.toString();
        }
        return this.fTaglabel;
    }

    public String toString() {
        return this.getTagName();
    }

    @Override
    public String getCompleteTag(int type, int member) {
        StringBuffer tag = new StringBuffer();
        tag.append(this.getTagName());
        String comment = this.getTagComment(type, member);
        if (EMPTY_STRING.equals(comment)) {
            return tag.toString();
        }
        tag.append(" ");
        tag.append(comment);
        return tag.toString();
    }

    @Override
    public boolean isApplicable(int type, int member) {
        return this.fTagItems != null && this.fTagItems.keySet().contains(this.getTagKey(type, member));
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiJavadocTag) {
            return ((IApiJavadocTag)obj).getTagName().equals(this.getTagName());
        }
        if (obj instanceof String) {
            return ((String)obj).equals(this.getTagName());
        }
        return false;
    }

    public int hashCode() {
        return this.getTagName().hashCode();
    }

    private Integer getTagKey(int type, int member) {
        return (type | member) + this.hashCode();
    }
}

