/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.AddCustomConstructorOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsContentProvider;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsSelectionDialog;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsValidator;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class GenerateNewConstructorUsingFieldsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public GenerateNewConstructorUsingFieldsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public GenerateNewConstructorUsingFieldsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.GenerateConstructorUsingFieldsAction_label);
        this.setDescription(ActionMessages.GenerateConstructorUsingFieldsAction_description);
        this.setToolTipText(ActionMessages.GenerateConstructorUsingFieldsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.create_new_constructor_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isAnnotation() && !type.isAnonymous();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields != null && fields.length > 0) {
            int index = 0;
            while (index < fields.length) {
                if (JdtFlags.isEnum((IMember)fields[index])) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_enum_not_applicable);
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        if (elements.size() > 0) {
            IField[] fields = new IField[elements.size()];
            ICompilationUnit unit = null;
            int index = 0;
            while (index < elements.size()) {
                IField field;
                block7: {
                    if (elements.get(index) instanceof IField) {
                        field = (IField)elements.get(index);
                        if (index == 0 ? (unit = field.getCompilationUnit()) == null : !unit.equals(field.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            IType declaringType = field.getDeclaringType();
                            if (declaringType.isInterface() || declaringType.isAnnotation() || declaringType.isAnonymous()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            return null;
                        }
                    }
                    return null;
                }
                fields[index] = field;
                ++index;
            }
            return fields;
        }
        return null;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type = (IType)elements[0];
            if (type.getCompilationUnit() != null && !type.isInterface() && !type.isAnnotation()) {
                return type;
            }
        } else if (elements[0] instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)elements[0];
            IType type = unit.findPrimaryType();
            if (type != null && !type.isInterface() && !type.isAnnotation()) {
                return type;
            }
        } else if (elements[0] instanceof IField) {
            return ((IField)elements[0]).getCompilationUnit().findPrimaryType();
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            IType selectionType = this.getSelectedType(selection);
            if (selectionType == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            IField[] selectedFields = this.getSelectedFields(selection);
            if (this.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            this.notifyResult(false);
            return;
        }
        try {
            IType type;
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, false);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null) {
                if (type.getFields().length > 0) {
                    this.run(type, new IField[0], true);
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_typeContainsNoFields_message);
                }
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_not_applicable);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
        catch (InvocationTargetException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    void run(IType type, IField[] selectedFields, boolean activated) throws CoreException {
        int dialogResult;
        block30: {
            if (!ElementValidator.check((IJavaElement)type, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, activated)) {
                this.notifyResult(false);
                return;
            }
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
                this.notifyResult(false);
                return;
            }
            ICompilationUnit cu = type.getCompilationUnit();
            if (cu == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateNewConstructorUsingFieldsAction_error_not_a_source_file);
                this.notifyResult(false);
                return;
            }
            List<IField> allSelected = Arrays.asList(selectedFields);
            CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)cu, SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            ITypeBinding typeBinding = ASTNodes.getTypeBinding(astRoot, type);
            if (typeBinding == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateNewConstructorUsingFieldsAction_error_not_a_source_file);
                this.notifyResult(false);
                return;
            }
            HashMap<IJavaElement, IVariableBinding> fieldsToBindings = new HashMap<IJavaElement, IVariableBinding>();
            ArrayList<IVariableBinding> selected = new ArrayList<IVariableBinding>();
            IVariableBinding[] candidates = typeBinding.getDeclaredFields();
            int i = 0;
            while (i < candidates.length) {
                ASTNode declaringNode;
                IVariableBinding curr = candidates[i];
                if (!(curr.isSynthetic() || Modifier.isStatic((int)curr.getModifiers()) || Modifier.isFinal((int)curr.getModifiers()) && (declaringNode = astRoot.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && ((VariableDeclarationFragment)declaringNode).getInitializer() != null)) {
                    IJavaElement javaElement = curr.getJavaElement();
                    fieldsToBindings.put(javaElement, curr);
                    if (allSelected.contains(javaElement)) {
                        selected.add(curr);
                    }
                }
                ++i;
            }
            if (fieldsToBindings.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_typeContainsNoFields_message);
                this.notifyResult(false);
                return;
            }
            ArrayList<IVariableBinding> fields = new ArrayList<IVariableBinding>();
            IField[] allFields = type.getFields();
            int i2 = 0;
            while (i2 < allFields.length) {
                IVariableBinding fieldBinding = (IVariableBinding)fieldsToBindings.remove(allFields[i2]);
                if (fieldBinding != null) {
                    fields.add(fieldBinding);
                }
                ++i2;
            }
            fields.addAll(fieldsToBindings.values());
            GenerateConstructorUsingFieldsContentProvider provider = new GenerateConstructorUsingFieldsContentProvider(fields, selected);
            IMethodBinding[] bindings = null;
            if (typeBinding.isAnonymous()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_anonymous_class);
                this.notifyResult(false);
                return;
            }
            if (typeBinding.isEnum()) {
                bindings = new IMethodBinding[]{this.getObjectConstructor(astRoot.getAST())};
            } else {
                bindings = StubUtility2.getVisibleConstructors(typeBinding, false, true);
                if (bindings.length == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_nothing_found);
                    this.notifyResult(false);
                    return;
                }
            }
            GenerateConstructorUsingFieldsSelectionDialog dialog = new GenerateConstructorUsingFieldsSelectionDialog(this.getShell(), (ILabelProvider)new BindingLabelProvider(), provider, this.fEditor, type, bindings);
            dialog.setCommentString(ActionMessages.SourceActionDialog_createConstructorComment);
            dialog.setTitle(ActionMessages.GenerateConstructorUsingFieldsAction_dialog_title);
            dialog.setInitialSelections(provider.getInitiallySelectedElements());
            dialog.setContainerMode(true);
            dialog.setSize(60, 18);
            dialog.setInput(new Object());
            dialog.setMessage(ActionMessages.GenerateConstructorUsingFieldsAction_dialog_label);
            dialog.setValidator(new GenerateConstructorUsingFieldsValidator(dialog, typeBinding, fields.size()));
            dialogResult = dialog.open();
            if (dialogResult == 0) {
                IRewriteTarget target;
                Object[] elements = dialog.getResult();
                if (elements == null) {
                    this.notifyResult(false);
                    return;
                }
                ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>(elements.length);
                int index = 0;
                while (index < elements.length) {
                    if (elements[index] instanceof IVariableBinding) {
                        result.add((IVariableBinding)elements[index]);
                    }
                    ++index;
                }
                IVariableBinding[] variables = result.toArray(new IVariableBinding[result.size()]);
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)cu);
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
                settings.createComments = dialog.getGenerateComment();
                IMethodBinding constructor = dialog.getSuperConstructorChoice();
                IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
                if (target != null) {
                    target.beginCompoundChange();
                }
                try {
                    Object context;
                    AddCustomConstructorOperation operation = new AddCustomConstructorOperation(astRoot, typeBinding, variables, constructor, dialog.getElementPosition(), settings, true, false);
                    operation.setVisibility(dialog.getVisibilityModifier());
                    if (constructor.getParameterTypes().length == 0) {
                        operation.setOmitSuper(dialog.isOmitSuper());
                    }
                    if ((context = JavaPlugin.getActiveWorkbenchWindow()) == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                }
                catch (InvocationTargetException exception) {
                    ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
                    if (target != null) {
                        target.endCompoundChange();
                    }
                    break block30;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (target != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                if (target == null) break block30;
                target.endCompoundChange();
            }
        }
        this.notifyResult(dialogResult == 0);
    }

    private IMethodBinding getObjectConstructor(AST ast) {
        ITypeBinding binding = ast.resolveWellKnownType("java.lang.Object");
        return Bindings.findMethodInType(binding, "Object", new ITypeBinding[0]);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }
}

