/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.identity;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;

public class FileTransferNamespace
extends Namespace {
    private static final long serialVersionUID = 8204058147686930765L;
    public static final String PROTOCOL = Messages.FileTransferNamespace_Namespace_Protocol;

    private String getInitFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + ":")) {
            int index = arg.indexOf(":");
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public ID createInstance(Object[] args) throws IDCreateException {
        try {
            String init = this.getInitFromExternalForm(args);
            if (init != null) {
                return new FileTransferID((Namespace)this, new URI(init));
            }
            if (args[0] instanceof URL) {
                return new FileTransferID((Namespace)this, (URL)args[0]);
            }
            if (args[0] instanceof String) {
                return new FileTransferID((Namespace)this, new URI((String)args[0]));
            }
            if (args[0] instanceof URI) {
                return new FileTransferID((Namespace)this, (URI)args[0]);
            }
        }
        catch (Exception e) {
            throw new IDCreateException(Messages.FileTransferNamespace_Exception_Create_Instance, (Throwable)e);
        }
        throw new IDCreateException(Messages.FileTransferNamespace_Exception_Create_Instance_Failed);
    }

    public String[] getSupportedSchemes() {
        HashSet<String> result = new HashSet<String>();
        String[] platformSchemes = Activator.getDefault().getPlatformSupportedSchemes();
        int i = 0;
        while (i < platformSchemes.length) {
            result.add(platformSchemes[i]);
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public String getScheme() {
        return PROTOCOL;
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{URL.class}, {String.class}};
    }
}

