/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.ecl.TeslaErrorStatus;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.ServiceUtil;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ContainsImage;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetRegionText;
import org.eclipse.rcptt.util.Base64;

public class IMLContainsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        TeslaBridge.waitDelay();
        try {
            if (command instanceof ContainsImage) {
                ContainsImage ct = (ContainsImage)command;
                ControlUIElement controlUIElement = this.getControlUIElement(ct.getControl());
                byte[] decode = Base64.decode((String)ct.getRawImage());
                controlUIElement.doContainsImageAssert(decode);
                TeslaErrorStatus error = TeslaBridge.getTeslaFailure();
                if (error == null) {
                    context.getOutput().write((Object)ServiceUtil.wrap(Boolean.TRUE));
                    return Status.OK_STATUS;
                }
                context.getOutput().write((Object)ServiceUtil.wrap(Boolean.FALSE));
                return Status.OK_STATUS;
            }
            if (command instanceof GetRegionText) {
                GetRegionText rct = (GetRegionText)command;
                ControlUIElement controlUIElement = this.getControlUIElement(rct.getControl());
                String text = controlUIElement.getRegionText(rct.getX().intValue(), rct.getY().intValue(), rct.getSx().intValue(), rct.getSy().intValue(), rct.getWidth().intValue(), rct.getHeight().intValue());
                TeslaErrorStatus error = TeslaBridge.getTeslaFailure();
                if (error == null) {
                    context.getOutput().write((Object)ServiceUtil.wrap(text));
                    return Status.OK_STATUS;
                }
                context.getOutput().write((Object)ServiceUtil.wrap(""));
                return Status.OK_STATUS;
            }
        }
        catch (Throwable e) {
            TeslaImplPlugin.err("IMLContainsService error:", e);
        }
        context.getOutput().write((Object)ServiceUtil.wrap(false));
        return Status.OK_STATUS;
    }

    private ControlUIElement getControlUIElement(ControlHandler control) throws CoreException {
        ControlUIElement element = new ControlUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        return element;
    }
}

