/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.PluginPreferenceInitializer;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CommittingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button warnCheckbox;
    private Group buildProblemsGroup;
    private ComboFieldEditor warnCombo;
    private Button blockCheckbox;
    private ComboFieldEditor blockCombo;

    public CommittingPreferencePage() {
        super(1);
        this.setTitle(UIText.CommittingPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        Composite main = this.getFieldEditorParent();
        BooleanFieldEditor useStagingView = new BooleanFieldEditor("always_use_staging_view", UIText.CommittingPreferencePage_AlwaysUseStagingView, main);
        this.addField((FieldEditor)useStagingView);
        Group formattingGroup = new Group(main, 16);
        formattingGroup.setText(UIText.CommittingPreferencePage_formatting);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)formattingGroup);
        BooleanFieldEditor hardWrap = new BooleanFieldEditor("commit_dialog_hard_wrap_message", UIText.CommittingPreferencePage_hardWrapMessage, (Composite)formattingGroup);
        hardWrap.getDescriptionControl((Composite)formattingGroup).setToolTipText(UIText.CommittingPreferencePage_hardWrapMessageTooltip);
        this.addField((FieldEditor)hardWrap);
        BooleanFieldEditor secondLineCheck = new BooleanFieldEditor("commit_dialog_warn_about_message_second_line", UIText.CommittingPreferencePage_warnAboutCommitMessageSecondLine, (Composite)formattingGroup);
        this.addField((FieldEditor)secondLineCheck);
        this.updateMargins(formattingGroup);
        Group footersGroup = new Group(main, 16);
        footersGroup.setText(UIText.CommittingPreferencePage_footers);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)footersGroup);
        BooleanFieldEditor signedOffBy = new BooleanFieldEditor("commit_dialog_signed_off_by", UIText.CommittingPreferencePage_signedOffBy, (Composite)footersGroup);
        signedOffBy.getDescriptionControl((Composite)footersGroup).setToolTipText(UIText.CommittingPreferencePage_signedOffByTooltip);
        this.addField((FieldEditor)signedOffBy);
        this.updateMargins(footersGroup);
        this.buildProblemsGroup = this.createGroup(main, 1);
        this.buildProblemsGroup.setText(UIText.CommittingPreferencePage_WarnBeforeCommittingTitle);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.buildProblemsGroup);
        this.warnCheckbox = this.createCheckBox((Composite)this.buildProblemsGroup, UIText.CommittingPreferencePage_CheckBeforeCommitting);
        ((GridData)this.warnCheckbox.getLayoutData()).horizontalSpan = 3;
        this.warnCheckbox.setSelection(this.doGetPreferenceStore().getBoolean("checkBeforeCommitting"));
        this.warnCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommittingPreferencePage.this.handleWarnCheckboxSelection(CommittingPreferencePage.this.warnCheckbox.getSelection());
            }
        });
        this.warnCombo = new ComboFieldEditor("warnBeforeCommitting", UIText.CommittingPreferencePage_WarnBeforeCommitting, (String[][])new String[][]{{UIText.CommittingPreferencePage_WarnBlock_Errors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_ERRORS}, {UIText.CommittingPreferencePage_WarnBlock_WarningsAndErrors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_WARNINGS_AND_ERRORS}}, (Composite)this.buildProblemsGroup);
        this.addField((FieldEditor)this.warnCombo);
        this.blockCheckbox = this.createCheckBox((Composite)this.buildProblemsGroup, UIText.CommittingPreferencePage_BlockCommit);
        ((GridData)this.blockCheckbox.getLayoutData()).horizontalSpan = 3;
        this.blockCheckbox.setSelection(this.doGetPreferenceStore().getBoolean("blockCommit"));
        this.blockCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommittingPreferencePage.this.handleBlockCheckboxSelection(CommittingPreferencePage.this.blockCheckbox.getSelection());
            }
        });
        this.blockCombo = new ComboFieldEditor("blockCommitCombo", UIText.CommittingPreferencePage_BlockCommitCombo, (String[][])new String[][]{{UIText.CommittingPreferencePage_WarnBlock_Errors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_ERRORS}, {UIText.CommittingPreferencePage_WarnBlock_WarningsAndErrors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_WARNINGS_AND_ERRORS}}, (Composite)this.buildProblemsGroup);
        this.addField((FieldEditor)this.blockCombo);
        this.handleWarnCheckboxSelection(this.warnCheckbox.getSelection());
        this.handleBlockCheckboxSelection(this.blockCheckbox.getSelection());
        this.updateMargins(this.buildProblemsGroup);
        BooleanFieldEditor includeUntracked = new BooleanFieldEditor("commit_dialog_include_untracked", UIText.CommittingPreferencePage_includeUntrackedFiles, main);
        includeUntracked.getDescriptionControl(main).setToolTipText(UIText.CommittingPreferencePage_includeUntrackedFilesTooltip);
        this.addField((FieldEditor)includeUntracked);
        IntegerFieldEditor historySize = new IntegerFieldEditor("commit_dialog_history_size", UIText.CommittingPreferencePage_commitMessageHistory, main);
        this.addField((FieldEditor)historySize);
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void handleBlockCheckboxSelection(boolean selection) {
        this.blockCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
    }

    private void handleWarnCheckboxSelection(boolean selection) {
        this.warnCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
        this.blockCheckbox.setEnabled(selection);
        this.blockCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
    }

    public boolean performOk() {
        this.doGetPreferenceStore().setValue("checkBeforeCommitting", this.warnCheckbox.getSelection());
        this.doGetPreferenceStore().setValue("blockCommit", this.blockCheckbox.getSelection());
        return super.performOk();
    }

    private Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 0x1000008;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }
}

