/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.rfs.spi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.rfs.ReviewsRFSProxy;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;

public class RFSRegistryFactory {
    private static final Map<R4EReviewGroup, ReviewsRFSProxy> fOpenStore = new HashMap<R4EReviewGroup, ReviewsRFSProxy>();

    public static IRFSRegistry getRegistry(R4EReview aReview) throws ReviewsFileStorageException {
        R4EReviewGroup group = (R4EReviewGroup)aReview.eContainer();
        ReviewsRFSProxy cachedGroupStorage = fOpenStore.get(group);
        if (cachedGroupStorage != null) {
            return cachedGroupStorage;
        }
        Set<R4EReviewGroup> groups = fOpenStore.keySet();
        for (R4EReviewGroup oGroup : groups) {
            ReviewsRFSProxy rfs = fOpenStore.get(oGroup);
            if (rfs == null) continue;
            rfs.close();
        }
        fOpenStore.clear();
        File groupDir = new File(group.getFolder());
        ReviewsRFSProxy fsStore = new ReviewsRFSProxy(groupDir, false);
        fOpenStore.put(group, fsStore);
        return fsStore;
    }
}

