/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.vcalendar.core;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;

public class VCalendar {
    private long fTIME_ZONE_OFFSET = TimeZone.getDefault().getOffset(System.currentTimeMillis());
    private final String fNEW_LINE = "\n";
    private final String fGMT_TIME = "Z";
    private final SimpleDateFormat fDATE_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss", new Locale("eng", "US"));

    public String createVCalendar(IMeetingData aInfo, String aFrom, String[] aEmails) {
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN:VCALENDAR");
        sb.append("\n");
        sb.append("PRODID:-//Microsoft Corporation//Outlook 11.0 MIMEDIR//EN");
        sb.append("\n");
        sb.append("VERSION:1.0");
        sb.append("\n");
        sb.append("BEGIN:VEVENT");
        sb.append("\n");
        sb.append("ATTENDEE:");
        sb.append(this.getAttendee(aEmails));
        sb.append("\n");
        sb.append("DTSTART:");
        sb.append(this.getStartDate(aInfo));
        sb.append("Z");
        sb.append("\n");
        sb.append("DTEND:");
        sb.append(this.getEndDate(aInfo));
        sb.append("Z");
        sb.append("\n");
        sb.append("LOCATION:");
        sb.append(aInfo.getLocation());
        sb.append("\n");
        sb.append("DESCRIPTION;ENCODING=QUOTED-PRINTABLE:");
        sb.append(this.reformatMessageBody(aInfo.getBody()));
        sb.append("=0D=0A");
        sb.append("\n");
        sb.append("SUMMARY;ENCODING=QUOTED-PRINTABLE:");
        sb.append(aInfo.getSubject());
        sb.append("\n");
        sb.append("PRIORITY:3");
        sb.append("\n");
        sb.append("END:VEVENT");
        sb.append("\n");
        sb.append("END:VCALENDAR");
        return sb.toString();
    }

    private String reformatMessageBody(String aBody) {
        String lineSeparator = System.getProperty("line.separator");
        String str = aBody.trim().replaceAll(lineSeparator, "=0D=0A");
        str = str.replaceAll("\n", "=0D=0A");
        str = str.replaceAll("\r", "=0D=0A");
        return str;
    }

    private String getAttendee(String[] aEmails) {
        StringBuffer sb = new StringBuffer();
        int size = aEmails.length;
        int i = 0;
        while (i < size) {
            sb.append("\"MAILTO:");
            sb.append(aEmails[i]);
            if (i < size - 1) {
                sb.append("\",");
            } else {
                sb.append('\"');
            }
            ++i;
        }
        return sb.toString();
    }

    private String getStartDate(IMeetingData aInfo) {
        return this.fDATE_FORMAT.format(aInfo.getStartTime() - this.fTIME_ZONE_OFFSET);
    }

    private String getEndDate(IMeetingData aInfo) {
        Long timeDuration = aInfo.getDuration() * 60 * 1000;
        return this.fDATE_FORMAT.format(aInfo.getStartTime() + timeDuration - this.fTIME_ZONE_OFFSET);
    }
}

