/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ReviewGroupTabPropertySection
extends ModelElementTabPropertySection
implements IEditableListListener {
    private static final String PROJ_COMP_SECTION_LABEL = "Projects and Components";
    private static final String RULE_SETS_SECTION_LABEL = "Rule Sets";
    private Text fNameText = null;
    private Text fFilePathText = null;
    protected Text fDescriptionText = null;
    protected EditableListWidget fAvailableProjects = null;
    protected EditableListWidget fAvailableComponents = null;
    protected Text fDefaultEntryCriteriaText = null;
    protected EditableListWidget fRuleSetLocations = null;

    public void dispose() {
        if (this.fAvailableProjects != null) {
            this.fAvailableProjects.dispose();
        }
        if (this.fAvailableComponents != null) {
            this.fAvailableComponents.dispose();
        }
        super.dispose();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fNameText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fNameText.setEditable(false);
        this.fNameText.setToolTipText("The Name that Identifies the Review Group");
        this.fNameText.setLayoutData((Object)data);
        CLabel nameLabel = widgetFactory.createCLabel(composite, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNameText, -5);
        data.top = new FormAttachment((Control)this.fNameText, 0, 0x1000000);
        nameLabel.setToolTipText("The Name that Identifies the Review Group");
        nameLabel.setLayoutData((Object)data);
        this.fFilePathText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNameText, 4);
        this.fFilePathText.setEditable(false);
        this.fFilePathText.setToolTipText("The Location (Folder) where the Review Group Information is Stored.  Review Group Information is stored in files that have a _group_root.xrer suffix");
        this.fFilePathText.setLayoutData((Object)data);
        CLabel folderLabel = widgetFactory.createCLabel(composite, "File: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fFilePathText, -5);
        data.top = new FormAttachment((Control)this.fFilePathText, 0, 0x1000000);
        folderLabel.setToolTipText("The Location (Folder) where the Review Group Information is Stored.  Review Group Information is stored in files that have a _group_root.xrer suffix");
        folderLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fDescriptionText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fFilePathText, 4);
        this.fDescriptionText.setToolTipText("A Brief Description of ths Review Group");
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewGroupTabPropertySection.this.fRefreshInProgress && ReviewGroupTabPropertySection.this.fDescriptionText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReviewGroup modelGroup = ((R4EUIReviewGroup)ReviewGroupTabPropertySection.this.fProperties.getElement()).getReviewGroup();
                        String newValue = ReviewGroupTabPropertySection.this.fDescriptionText.getText().trim();
                        if (!newValue.equals(modelGroup.getDescription())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                            modelGroup.setDescription(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewGroupTabPropertySection.this.fDescriptionText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDescriptionText);
        CLabel descriptionLabel = widgetFactory.createCLabel(composite, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("A Brief Description of ths Review Group");
        descriptionLabel.setLayoutData((Object)data);
        this.fDefaultEntryCriteriaText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDescriptionText, 4);
        this.fDefaultEntryCriteriaText.setToolTipText("The Entry Criteria that will be used for all Reviews created under this Review Group");
        this.fDefaultEntryCriteriaText.setLayoutData((Object)data);
        this.fDefaultEntryCriteriaText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewGroupTabPropertySection.this.fRefreshInProgress && ReviewGroupTabPropertySection.this.fDefaultEntryCriteriaText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReviewGroup modelGroup = ((R4EUIReviewGroup)ReviewGroupTabPropertySection.this.fProperties.getElement()).getReviewGroup();
                        String newValue = ReviewGroupTabPropertySection.this.fDefaultEntryCriteriaText.getText().trim();
                        if (!newValue.equals(modelGroup.getDefaultEntryCriteria())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                            modelGroup.setDefaultEntryCriteria(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewGroupTabPropertySection.this.fDefaultEntryCriteriaText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDefaultEntryCriteriaText);
        CLabel entryCriteriaLabel = widgetFactory.createCLabel(composite, "Default Entry Criteria: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDefaultEntryCriteriaText, -5);
        data.top = new FormAttachment((Control)this.fDefaultEntryCriteriaText, 0, 0x1000000);
        entryCriteriaLabel.setToolTipText("The Entry Criteria that will be used for all Reviews created under this Review Group");
        entryCriteriaLabel.setLayoutData((Object)data);
        this.createRuleSetSection(widgetFactory, composite, this.createProjectCompSection(widgetFactory, composite));
    }

    private Composite createProjectCompSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite) {
        ExpandableComposite projCompSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDefaultEntryCriteriaText, 4);
        projCompSection.setLayoutData((Object)data);
        projCompSection.setText(PROJ_COMP_SECTION_LABEL);
        projCompSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        projCompSection.setLayout((Layout)new GridLayout(1, false));
        Composite projCompSectionClient = aWidgetFactory.createComposite((Composite)projCompSection);
        projCompSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        projCompSectionClient.setLayout((Layout)new GridLayout(4, false));
        projCompSection.setClient((Control)projCompSectionClient);
        CLabel projectsLabel = aWidgetFactory.createCLabel(projCompSectionClient, "Available Projects: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        projectsLabel.setToolTipText("The Projects that are available for Review in this Review Group.  Take Note that these Project can have Arbitrary Names, not only Eclipse Project Names");
        projectsLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fAvailableProjects = new EditableListWidget((FormToolkit)aWidgetFactory, projCompSectionClient, gridData, this, 1, Text.class, null);
        this.fAvailableProjects.setToolTipText("The Projects that are available for Review in this Review Group.  Take Note that these Project can have Arbitrary Names, not only Eclipse Project Names");
        CLabel componentsLabel = aWidgetFactory.createCLabel(projCompSectionClient, "Available Components: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        componentsLabel.setToolTipText("The Components (Subsystems, Sub-Projects etc.) that are available for Review in this Review Group.  These can have Arbitrary Names");
        componentsLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fAvailableComponents = new EditableListWidget((FormToolkit)aWidgetFactory, projCompSectionClient, gridData, this, 2, Text.class, null);
        this.fAvailableComponents.setToolTipText("The Components (Subsystems, Sub-Projects etc.) that are available for Review in this Review Group.  These can have Arbitrary Names");
        return projCompSection;
    }

    private void createRuleSetSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite, Composite aTopComposite) {
        ExpandableComposite ruleSetsSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aTopComposite, 4);
        ruleSetsSection.setLayoutData((Object)data);
        ruleSetsSection.setText(RULE_SETS_SECTION_LABEL);
        ruleSetsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        ruleSetsSection.setLayout((Layout)new GridLayout(1, false));
        Composite ruleSetSectionClient = aWidgetFactory.createComposite((Composite)ruleSetsSection);
        ruleSetSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        ruleSetSectionClient.setLayout((Layout)new GridLayout(4, false));
        ruleSetsSection.setClient((Control)ruleSetSectionClient);
        CLabel ruleSetsLabel = aWidgetFactory.createCLabel(ruleSetSectionClient, "Applied Rule Sets: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        ruleSetsLabel.setToolTipText("The Location of the RuleSet definition Files that can be used for Reviews created under this Review Group");
        ruleSetsLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fRuleSetLocations = new EditableListWidget((FormToolkit)aWidgetFactory, ruleSetSectionClient, gridData, this, 3, CCombo.class, null);
        this.fRuleSetLocations.setToolTipText("The Location of the RuleSet definition Files that can be used for Reviews created under this Review Group");
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EReviewGroup modelGroup = ((R4EUIReviewGroup)this.fProperties.getElement()).getReviewGroup();
        this.fNameText.setText(modelGroup.getName());
        if (((R4EUIReviewGroup)this.fProperties.getElement()).getReviewGroup().eResource() != null) {
            this.fFilePathText.setText(((R4EUIReviewGroup)this.fProperties.getElement()).getReviewGroup().eResource().getURI().toFileString());
        }
        if (modelGroup.getDescription() != null) {
            this.fDescriptionText.setText(modelGroup.getDescription());
        } else {
            this.fDescriptionText.setText("");
        }
        EList availableProjects = modelGroup.getAvailableProjects();
        String[] projects = (String[])availableProjects.toArray((Object[])new String[availableProjects.size()]);
        this.fAvailableProjects.removeAll();
        Item item = null;
        String project = null;
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            if (i >= this.fAvailableProjects.getItemCount()) {
                item = this.fAvailableProjects.addItem();
            } else {
                item = this.fAvailableProjects.getItem(i);
                if (item == null) {
                    item = this.fAvailableProjects.addItem();
                }
            }
            item.setText(project);
            ++i;
        }
        this.fAvailableProjects.updateButtons();
        EList availableComponents = modelGroup.getAvailableComponents();
        String[] components = (String[])availableComponents.toArray((Object[])new String[availableComponents.size()]);
        this.fAvailableComponents.removeAll();
        String component = null;
        int i2 = 0;
        while (i2 < components.length) {
            component = components[i2];
            if (i2 >= this.fAvailableComponents.getItemCount()) {
                item = this.fAvailableComponents.addItem();
            } else {
                item = this.fAvailableComponents.getItem(i2);
                if (item == null) {
                    item = this.fAvailableComponents.addItem();
                }
            }
            item.setText(component);
            ++i2;
        }
        this.fAvailableComponents.updateButtons();
        this.fDefaultEntryCriteriaText.setText(modelGroup.getDefaultEntryCriteria());
        List<R4EUIRuleSet> uiRuleSets = ((R4EUIRootElement)((R4EUIReviewGroup)this.fProperties.getElement()).getParent()).getRuleSets();
        ArrayList<String> tmpRuleSetLocations = new ArrayList<String>();
        EList ruleLocations = modelGroup.getDesignRuleLocations();
        String[] ruleSetsLocations = (String[])ruleLocations.toArray((Object[])new String[ruleLocations.size()]);
        for (R4EUIRuleSet uiRuleSet : uiRuleSets) {
            if (!uiRuleSet.isEnabled()) continue;
            tmpRuleSetLocations.add(uiRuleSet.getName());
        }
        this.fRuleSetLocations.setEditableValues(tmpRuleSetLocations.toArray(new String[tmpRuleSetLocations.size()]));
        this.fRuleSetLocations.removeAll();
        item = null;
        String ruleSet = null;
        int i3 = 0;
        while (i3 < ruleSetsLocations.length) {
            ruleSet = ruleSetsLocations[i3];
            if (i3 >= this.fRuleSetLocations.getItemCount()) {
                item = this.fRuleSetLocations.addItem();
            } else {
                item = this.fRuleSetLocations.getItem(i3);
                if (item == null) {
                    item = this.fRuleSetLocations.addItem();
                }
            }
            item.setText(ruleSet);
            item.setImage(null);
            List<R4EUIRuleSet> loadedRuleSets = R4EUIModelController.getRootElement().getRuleSets();
            for (R4EUIRuleSet loadedRuleSet : loadedRuleSets) {
                if (!ruleSet.equals(loadedRuleSet.getName())) continue;
                item.setImage(this.fProperties.getElement().getUserReviewedImage());
            }
            if (item.getImage() == null) {
                item.setImage(this.fProperties.getElement().getDisabledImage());
            }
            ++i3;
        }
        this.setEnabledFields();
        this.fRefreshInProgress = false;
        R4EUIModelController.setCurrentPropertySection(this);
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || !((R4EUIReviewGroup)this.fProperties.getElement()).isOpen() || !this.fProperties.getElement().isEnabled() || this.fProperties.getElement().isReadOnly()) {
            this.fNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fFilePathText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(false);
            this.fDefaultEntryCriteriaText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDefaultEntryCriteriaText.setEditable(false);
            this.fAvailableProjects.setEnabled(false);
            this.fAvailableComponents.setEnabled(false);
            this.fRuleSetLocations.setEnabled(false);
        } else {
            this.fNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fFilePathText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(true);
            this.fDefaultEntryCriteriaText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDefaultEntryCriteriaText.setEditable(true);
            this.fAvailableProjects.setEnabled(true);
            this.fAvailableComponents.setEnabled(true);
            this.fRuleSetLocations.setEnabled(true);
        }
    }

    public void itemsUpdated(Item[] aItems, int aInstanceId) {
        try {
            if (!this.fRefreshInProgress) {
                String currentUser = R4EUIModelController.getReviewer();
                R4EReviewGroup modelGroup = ((R4EUIReviewGroup)this.fProperties.getElement()).getReviewGroup();
                if (1 == aInstanceId) {
                    Long bookNum;
                    ArrayList<String> newAddProjects = new ArrayList<String>();
                    ArrayList<String> newDeleteProjects = new ArrayList<String>();
                    ArrayList storedProjects = new ArrayList();
                    storedProjects.addAll(modelGroup.getAvailableProjects());
                    Item[] itemArray = aItems;
                    int n = aItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Item item = itemArray[n2];
                        newAddProjects.add(item.getText());
                        newDeleteProjects.add(item.getText());
                        ++n2;
                    }
                    newAddProjects.removeAll(storedProjects);
                    if (newAddProjects.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getAvailableProjects().addAll(newAddProjects);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                    storedProjects.removeAll(newDeleteProjects);
                    if (storedProjects.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getAvailableProjects().removeAll(storedProjects);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                } else if (2 == aInstanceId) {
                    Long bookNum;
                    ArrayList<String> newAddComponents = new ArrayList<String>();
                    ArrayList<String> newDeleteComponents = new ArrayList<String>();
                    ArrayList storedComponents = new ArrayList();
                    storedComponents.addAll(modelGroup.getAvailableComponents());
                    Item[] itemArray = aItems;
                    int n = aItems.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Item item = itemArray[n3];
                        newAddComponents.add(item.getText());
                        newDeleteComponents.add(item.getText());
                        ++n3;
                    }
                    newAddComponents.removeAll(storedComponents);
                    if (newAddComponents.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getAvailableComponents().addAll(newAddComponents);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                    storedComponents.removeAll(newDeleteComponents);
                    if (storedComponents.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getAvailableComponents().removeAll(storedComponents);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                } else if (3 == aInstanceId) {
                    Long bookNum;
                    Item item;
                    ArrayList<String> newAddRuleSets = new ArrayList<String>();
                    ArrayList<String> newDeleteRuleSets = new ArrayList<String>();
                    ArrayList storedRuleSets = new ArrayList();
                    storedRuleSets.addAll(modelGroup.getDesignRuleLocations());
                    Item[] itemArray = aItems;
                    int n = aItems.length;
                    int n4 = 0;
                    while (n4 < n) {
                        item = itemArray[n4];
                        newAddRuleSets.add(item.getText());
                        newDeleteRuleSets.add(item.getText());
                        ++n4;
                    }
                    newAddRuleSets.removeAll(storedRuleSets);
                    if (newAddRuleSets.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getDesignRuleLocations().addAll(newAddRuleSets);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                    storedRuleSets.removeAll(newDeleteRuleSets);
                    if (storedRuleSets.size() > 0) {
                        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelGroup, currentUser);
                        modelGroup.getDesignRuleLocations().removeAll(storedRuleSets);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                    ((R4EUIReviewGroup)this.fProperties.getElement()).getRuleSets().clear();
                    itemArray = aItems;
                    n = aItems.length;
                    n4 = 0;
                    while (n4 < n) {
                        item = itemArray[n4];
                        for (R4EUIRuleSet ruleSet : ((R4EUIRootElement)((R4EUIReviewGroup)this.fProperties.getElement()).getParent()).getRuleSets()) {
                            if (!ruleSet.getName().equals(item.getText())) continue;
                            ((R4EUIReviewGroup)this.fProperties.getElement()).getRuleSets().add(ruleSet);
                            break;
                        }
                        ++n4;
                    }
                }
                this.refresh();
            }
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
    }

    public void setDescription(String aDescription) {
        this.refresh();
        this.fDescriptionText.setFocus();
        this.fDescriptionText.setText(aDescription);
        this.fDefaultEntryCriteriaText.setFocus();
    }

    public void setDefaultEntryCriteria(String aCriteria) {
        this.refresh();
        this.fDefaultEntryCriteriaText.setFocus();
        this.fDefaultEntryCriteriaText.setText(aCriteria);
        this.fDescriptionText.setFocus();
    }

    public void removeAvailableProject(String aProject) {
        this.refresh();
        this.fAvailableProjects.remove(aProject);
        this.fDescriptionText.setFocus();
    }

    public void addAvailableProject(String aProject) {
        this.refresh();
        this.fAvailableProjects.add(aProject);
        this.fDescriptionText.setFocus();
    }

    public void removeAvailableComponent(String aComponent) {
        this.refresh();
        this.fAvailableComponents.remove(aComponent);
        this.fDescriptionText.setFocus();
    }

    public void addAvailableComponent(String aComponent) {
        this.refresh();
        this.fAvailableComponents.add(aComponent);
        this.fDescriptionText.setFocus();
    }

    public void removeRuleSet(String aRuleSet) {
        this.refresh();
        this.fRuleSetLocations.remove(aRuleSet);
        this.fDescriptionText.setFocus();
    }

    public void addRuleSet(String aRuleSet) {
        this.refresh();
        this.fRuleSetLocations.add(aRuleSet);
        this.fDescriptionText.setFocus();
    }

    public void itemSelected(Item aItem, int aInstanceId) {
    }
}

