/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.filters;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;

public class ReviewParticipantFilter
extends ViewerFilter {
    private String fParticipant = "";

    public void setParticipant(String aParticipant) {
        this.fParticipant = aParticipant;
    }

    public String getParticipant() {
        return this.fParticipant;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof R4EUIReviewGroup && !((R4EUIReviewGroup)element).isOpen()) {
            return true;
        }
        if (this.isParentReviewParticipant((IR4EUIModelElement)element)) {
            return true;
        }
        return this.isChildrenReviewParticipant((IR4EUIModelElement)element);
    }

    private boolean isChildrenReviewParticipant(IR4EUIModelElement aCurrentElement) {
        int length = aCurrentElement.getChildren().length;
        IR4EUIModelElement element = null;
        int i = 0;
        while (i < length) {
            element = aCurrentElement.getChildren()[i];
            if (!(element instanceof R4EUIReviewBasic)) {
                return false;
            }
            if (((R4EUIReviewBasic)element).isParticipant(this.fParticipant)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isParentReviewParticipant(IR4EUIModelElement aCurrentElement) {
        IR4EUIModelElement reviewParentElement = aCurrentElement;
        while (!(reviewParentElement instanceof R4EUIReviewBasic)) {
            if ((reviewParentElement = reviewParentElement.getParent()) != null) continue;
            return false;
        }
        return ((R4EUIReviewBasic)reviewParentElement).isParticipant(this.fParticipant);
    }
}

