/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.StorageTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;

public class R4EFileRevisionTypedElement
extends StorageTypedElement {
    private final R4EFileVersion fFileVersion;
    private String fAuthor;

    public R4EFileRevisionTypedElement(R4EFileVersion aFileVersion) {
        this(aFileVersion, null);
    }

    public R4EFileRevisionTypedElement(R4EFileVersion aFileVersion, String aLocalEncoding) {
        super(aLocalEncoding);
        Assert.isNotNull((Object)aFileVersion);
        this.fFileVersion = aFileVersion;
    }

    public R4EFileVersion getFileVersion() {
        return this.fFileVersion;
    }

    public String getName() {
        return this.fFileVersion.getName();
    }

    protected IStorage fetchContents(IProgressMonitor aMonitor) {
        try {
            IRFSRegistry localRepository = RFSRegistryFactory.getRegistry((R4EReview)R4EUIModelController.getActiveReview().getReview());
            return localRepository.getIStorage(null, this.fFileVersion);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
            return null;
        }
    }

    public String getContentIdentifier() {
        return this.fFileVersion.getFileRevision().getContentIdentifier();
    }

    public String getTimestamp() {
        long date = this.fFileVersion.getFileRevision().getTimestamp();
        Date dateFromLong = new Date(date);
        return DateFormat.getDateTimeInstance().format(dateFromLong);
    }

    public String getPath() {
        URI uri = this.fFileVersion.getFileRevision().getURI();
        if (uri != null) {
            return uri.getPath();
        }
        return this.getName();
    }

    public IEditorInput getDocumentKey(Object aElement) {
        if (aElement.equals(this) && this.getBufferedStorage() != null) {
            return new R4EFileRevisionEditorInput(this.fFileVersion);
        }
        return null;
    }

    public int hashCode() {
        return this.fFileVersion.getFileRevision().hashCode();
    }

    public boolean equals(Object aObj) {
        if (aObj == this) {
            return true;
        }
        if (aObj instanceof R4EFileRevisionTypedElement) {
            R4EFileRevisionTypedElement other = (R4EFileRevisionTypedElement)aObj;
            return other.getFileVersion().equals(this.getFileVersion());
        }
        return false;
    }

    public String getAuthor() {
        if (this.fAuthor == null) {
            this.fAuthor = this.fFileVersion.getFileRevision().getAuthor();
        }
        return this.fAuthor;
    }

    public void setAuthor(String aAuthor) {
        this.fAuthor = aAuthor;
    }

    public void fetchAuthor(IProgressMonitor aMonitor) throws CoreException {
        if (this.getAuthor() == null && this.fFileVersion.getFileRevision().isPropertyMissing()) {
            IFileRevision other = this.fFileVersion.getFileRevision().withAllProperties(aMonitor);
            this.fAuthor = other.getAuthor();
        }
    }
}

