/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ECommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IAnomalyInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICalendarDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorLabelProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneAnomalyInputDialog
extends FormDialog
implements IAnomalyInputDialog {
    private static final String CLONE_ANOMALY_DIALOG_TITLE = "Select Anomaly to Clone";
    private static final String ANOMALY_LIST_HEADER_MSG = "Available Cloneable Anomalies";
    private static final String ANOMALY_DETAILS_HEADER_MSG = "Anomaly Details";
    private static final int MAX_DISPLAYED_CLONEABLE_ANOMALIES = 10;
    private TableViewer fCloneableAnomalyViewer = null;
    private R4EUIAnomalyBasic fClonedAnomaly = null;
    protected Text fAnomalyTitleTextField = null;
    protected Text fAnomalyDescriptionTextField;
    protected Text fAnomalyClassTextField = null;
    protected Text fAnomalyRankTextField = null;
    protected Text fDateText = null;
    private Date fAnomalyDueDateValue = null;
    private Text fRuleIdTextField = null;
    protected CCombo fAssignedToCombo = null;
    private String fAssignedToParticipant = null;

    public CloneAnomalyInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            ISelection selection = this.fCloneableAnomalyViewer.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() != null && ((IStructuredSelection)selection).getFirstElement() instanceof R4EUIAnomalyBasic) {
                this.fClonedAnomaly = (R4EUIAnomalyBasic)((IStructuredSelection)selection).getFirstElement();
                this.fAssignedToParticipant = this.fAssignedToCombo.getText();
            }
        } else {
            this.fClonedAnomaly = null;
            this.fAnomalyDueDateValue = null;
            this.fAssignedToParticipant = null;
        }
        R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CLONE_ANOMALY_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, true);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText(ANOMALY_LIST_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                CloneAnomalyInputDialog.this.getShell().setSize(CloneAnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Set<R4EUIAnomalyBasic> anomalies = this.getCloneableAnomalies();
        int tableHeight = 10;
        if (anomalies.size() < 10) {
            tableHeight = anomalies.size();
        }
        textGridData = new GridData(4, 4, true, true);
        this.fCloneableAnomalyViewer = new TableViewer(basicSectionClient, 68360);
        textGridData.heightHint = this.fCloneableAnomalyViewer.getTable().getItemHeight() * tableHeight;
        this.fCloneableAnomalyViewer.getControl().setLayoutData((Object)textGridData);
        this.fCloneableAnomalyViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fCloneableAnomalyViewer, (int)2);
        this.fCloneableAnomalyViewer.setLabelProvider((IBaseLabelProvider)new ReviewNavigatorLabelProvider(){

            public String getText(Object element) {
                return ((R4EUIAnomalyBasic)element).getAnomaly().getTitle();
            }

            public void update(ViewerCell cell) {
                cell.setText(((R4EUIAnomalyBasic)cell.getElement()).getAnomaly().getTitle());
                cell.setImage(((R4EUIAnomalyBasic)cell.getElement()).getImage(((R4EUIAnomalyBasic)cell.getElement()).getImageLocation()));
            }
        });
        this.fCloneableAnomalyViewer.setInput(anomalies);
        this.fCloneableAnomalyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject;
                CloneAnomalyInputDialog.this.getButton(0).setEnabled(false);
                if (event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() != null && (selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof R4EUIAnomalyBasic) {
                    R4EUIAnomalyBasic uiAnomaly = (R4EUIAnomalyBasic)selectedObject;
                    R4EAnomaly anomaly = uiAnomaly.getAnomaly();
                    if (anomaly != null) {
                        if (anomaly.getTitle() != null) {
                            CloneAnomalyInputDialog.this.fAnomalyTitleTextField.setText(anomaly.getTitle());
                        }
                        if (anomaly.getDescription() != null) {
                            CloneAnomalyInputDialog.this.fAnomalyDescriptionTextField.setText(anomaly.getDescription());
                        }
                        if (anomaly.getType() != null) {
                            CloneAnomalyInputDialog.this.fAnomalyClassTextField.setText(UIUtils.getClassStr(((R4ECommentType)anomaly.getType()).getType()));
                        }
                        if (anomaly.getRank() != null) {
                            CloneAnomalyInputDialog.this.fAnomalyRankTextField.setText(UIUtils.getRankStr(anomaly.getRank()));
                        }
                        if (anomaly.getRuleID() != null) {
                            String[] ar = anomaly.getRuleID().split("/");
                            String rule = ar[ar.length - 1];
                            CloneAnomalyInputDialog.this.fRuleIdTextField.setText(rule);
                            CloneAnomalyInputDialog.this.fRuleIdTextField.setToolTipText(anomaly.getRuleID());
                        }
                    }
                    CloneAnomalyInputDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        Section extraSection = toolkit.createSection(composite, 450);
        GridData extraSectionGridData = new GridData(4, 4, true, true);
        extraSectionGridData.horizontalSpan = 4;
        extraSection.setLayoutData((Object)extraSectionGridData);
        extraSection.setText(ANOMALY_DETAILS_HEADER_MSG);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                CloneAnomalyInputDialog.this.getShell().setSize(CloneAnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = toolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)layout);
        extraSection.setClient((Control)extraSectionClient);
        toolkit.setBorderStyle(0);
        Label label = toolkit.createLabel(extraSectionClient, "Anomaly Title: ");
        label.setToolTipText("A Title that Identifies this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyTitleTextField = toolkit.createText(extraSectionClient, "", 4);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyTitleTextField.setToolTipText("A Title that Identifies this Anomaly");
        this.fAnomalyTitleTextField.setLayoutData((Object)textGridData);
        this.fAnomalyTitleTextField.setEditable(false);
        label = toolkit.createLabel(extraSectionClient, "Anomaly Description: ");
        label.setToolTipText("A Detailed Description of the Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyDescriptionTextField = toolkit.createText(extraSectionClient, "", 770);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fAnomalyTitleTextField.getLineHeight() * 7;
        this.fAnomalyDescriptionTextField.setToolTipText("A Detailed Description of the Anomaly");
        this.fAnomalyDescriptionTextField.setLayoutData((Object)textGridData);
        this.fAnomalyDescriptionTextField.setEditable(false);
        label = toolkit.createLabel(extraSectionClient, "Class: ");
        label.setToolTipText("The Class of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyClassTextField = toolkit.createText(extraSectionClient, "", 4);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyClassTextField.setToolTipText("The Class of this Anomaly");
        this.fAnomalyClassTextField.setLayoutData((Object)textGridData);
        this.fAnomalyClassTextField.setEditable(false);
        label = toolkit.createLabel(extraSectionClient, "Rank: ");
        label.setToolTipText("The Rank (or Severity) of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyRankTextField = toolkit.createText(extraSectionClient, "", 4);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyRankTextField.setToolTipText("The Class of this Anomaly");
        this.fAnomalyRankTextField.setLayoutData((Object)textGridData);
        this.fAnomalyRankTextField.setEditable(false);
        label = toolkit.createLabel(extraSectionClient, "Rule ID: ");
        label.setToolTipText("An Tag that Identifies this Design Rule");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fRuleIdTextField = toolkit.createText(extraSectionClient, "", 4);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fRuleIdTextField.setToolTipText("The Class of this Anomaly");
        this.fRuleIdTextField.setLayoutData((Object)textGridData);
        this.fRuleIdTextField.setEditable(false);
        toolkit.setBorderStyle(2048);
        label = toolkit.createLabel(extraSectionClient, "Assigned to: ");
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        this.fAssignedToCombo = new CCombo(extraSectionClient, 2056);
        String[] participants = R4EUIModelController.getActiveReview().getParticipantIDs().toArray(new String[R4EUIModelController.getActiveReview().getParticipantIDs().size()]);
        this.fAssignedToCombo.removeAll();
        this.fAssignedToCombo.add("");
        String[] stringArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            String participant = stringArray[n2];
            this.fAssignedToCombo.add(participant);
            ++n2;
        }
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAssignedToCombo.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToCombo.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Due Date: ");
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        Composite dateComposite = toolkit.createComposite(extraSectionClient);
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 3;
        dateComposite.setToolTipText("The Target Date to Address this Anomaly");
        dateComposite.setLayoutData((Object)textGridData);
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.fDateText = toolkit.createText(dateComposite, "", 2056);
        this.fDateText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDateText.setEditable(false);
        Button calendarButton = toolkit.createButton(dateComposite, "...", 0);
        calendarButton.setLayoutData((Object)new GridData(4, 4, false, false));
        calendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ICalendarDialog dialog = R4EUIDialogFactory.getInstance().getCalendarDialog();
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
                    Date dialogDate = dialog.getDate();
                    String dialogDateStr = dateFormat.format(dialogDate);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.add(6, -1);
                    if (dialogDate.after(cal.getTime())) {
                        CloneAnomalyInputDialog.this.fDateText.setText(dialogDateStr);
                        CloneAnomalyInputDialog.this.fAnomalyDueDateValue = dialogDate;
                    } else {
                        UIUtils.displayPastDateError(dialogDate, dialogDateStr);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Set<R4EUIAnomalyBasic> getCloneableAnomalies() {
        HashSet<R4EUIAnomalyBasic> cloneableAnomalies = new HashSet<R4EUIAnomalyBasic>();
        R4EUIReviewBasic parentReview = R4EUIModelController.getActiveReview();
        for (R4EUIReviewItem items : parentReview.getReviewItems()) {
            if (!items.getItem().isEnabled()) continue;
            for (R4EUIFileContext file : items.getFileContexts()) {
                if (!file.getFileContext().isEnabled()) continue;
                IR4EUIModelElement[] iR4EUIModelElementArray = file.getAnomalyContainerElement().getChildren();
                int n = iR4EUIModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IR4EUIModelElement anomaly = iR4EUIModelElementArray[n2];
                    if (((R4EUIAnomalyBasic)anomaly).getAnomaly().isEnabled()) {
                        boolean isDuplicate = false;
                        for (R4EUIAnomalyBasic oldAnomaly : cloneableAnomalies) {
                            if (!oldAnomaly.isSameAs((R4EUIAnomalyBasic)anomaly)) continue;
                            isDuplicate = true;
                            break;
                        }
                        if (!isDuplicate) {
                            cloneableAnomalies.add((R4EUIAnomalyBasic)anomaly);
                        }
                    }
                    ++n2;
                }
            }
        }
        return cloneableAnomalies;
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public String getAnomalyTitleValue() {
        String title = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null) {
            title = this.fClonedAnomaly.getAnomaly().getTitle();
        }
        return title;
    }

    @Override
    public String getAnomalyDescriptionValue() {
        String description = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null) {
            description = this.fClonedAnomaly.getAnomaly().getDescription();
        }
        return description;
    }

    @Override
    public R4EDesignRule getRuleReferenceValue() {
        R4EDesignRule rule = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null) {
            rule = this.fClonedAnomaly.getAnomaly().getRule();
        }
        return rule;
    }

    @Override
    public void setClass_(R4EDesignRuleClass aClass) {
        if (aClass != null) {
            this.fAnomalyClassTextField.setText(UIUtils.getClassStr(aClass));
        }
    }

    @Override
    public R4EDesignRuleClass getClass_() {
        R4EDesignRuleClass class_ = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null && this.fClonedAnomaly.getAnomaly().getType() != null) {
            class_ = ((R4ECommentType)this.fClonedAnomaly.getAnomaly().getType()).getType();
        }
        return class_;
    }

    @Override
    public void setRank(R4EDesignRuleRank aRank) {
        if (aRank != null) {
            this.fAnomalyRankTextField.setText(UIUtils.getRankStr(aRank));
        }
    }

    @Override
    public R4EDesignRuleRank getRank() {
        R4EDesignRuleRank rank = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null) {
            rank = this.fClonedAnomaly.getAnomaly().getRank();
        }
        return rank;
    }

    @Override
    public void setDueDate(Date aDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
        if (aDate != null) {
            this.fDateText.setText(dateFormat.format(aDate));
        }
    }

    @Override
    public Date getDueDate() {
        if (this.fAnomalyDueDateValue != null) {
            return new Date(this.fAnomalyDueDateValue.getTime());
        }
        return null;
    }

    @Override
    public void setTitle(String aTitle) {
        this.fAnomalyTitleTextField.setText(aTitle);
    }

    @Override
    public void setDescription(String aDescription) {
        this.fAnomalyDescriptionTextField.setText(aDescription);
    }

    @Override
    public String getRuleID() {
        String rule = null;
        if (this.fClonedAnomaly != null && this.fClonedAnomaly.getAnomaly() != null) {
            rule = this.fClonedAnomaly.getAnomaly().getRuleID();
        }
        return rule;
    }

    @Override
    public void setRuleID(String aId) {
        this.fRuleIdTextField.setText(aId);
    }

    @Override
    public String getAssigned() {
        return this.fAssignedToParticipant;
    }

    @Override
    public void setAssigned(String aParticipant) {
        this.fAssignedToCombo.setText(aParticipant);
    }

    protected void setShellStyle(int newShellStyle) {
        int newstyle = newShellStyle & 0xFFFEFFFF;
        super.setShellStyle(newstyle);
    }

    @Override
    public int open() {
        super.open();
        this.pumpMessages();
        return super.getReturnCode();
    }

    protected void pumpMessages() {
        Shell sh = this.getShell();
        Display disp = sh.getDisplay();
        while (!sh.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
        disp.update();
    }
}

