/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.utils.sys;

import java.io.File;
import org.eclipse.core.runtime.Platform;

public final class OSPLATFORM {
    public static final String NAME = System.getProperty("os.name");
    public static final OSTYPE TYPE = OSTYPE.resolveOSNameToOSType(NAME);
    public static final String FILE_PATH_SEPARATOR = File.pathSeparator;
    public static final char FILE_PATH_SEPARATOR_CHAR = File.pathSeparatorChar;
    public static final String FILE_ELEMENT_SEPARATOR = File.separator;
    public static final char FILE_ELEMENT_SEPARATOR_CHAR = File.separatorChar;
    public static final String FILE_ELEMENT_SEPARATOR_PORTABLE = new String("/");
    public static final boolean IS_FILE_ELEMENT_SEPARATOR_PORTABLE = FILE_ELEMENT_SEPARATOR_PORTABLE.equals(FILE_ELEMENT_SEPARATOR);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSTYPE {
        WINDOWS{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("win32")) {
                    type = WINDOWS;
                }
                return type;
            }
        }
        ,
        LINUX{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("linux")) {
                    type = LINUX;
                }
                return type;
            }
        }
        ,
        SOLARIS{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("solaris")) {
                    type = SOLARIS;
                }
                return type;
            }
        }
        ,
        MAC{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("macosx")) {
                    type = MAC;
                }
                return type;
            }
        };


        protected abstract OSTYPE match(String var1);

        protected static OSTYPE resolveOSNameToOSType(String name) {
            OSTYPE type = null;
            OSTYPE[] oSTYPEArray = OSTYPE.values();
            int n = oSTYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                OSTYPE t = oSTYPEArray[n2];
                type = t.match(name);
                if (type != null) break;
                ++n2;
            }
            return type;
        }

        public boolean isWindowsOS() {
            return this == WINDOWS;
        }

        public boolean isLinuxOS() {
            return this == LINUX;
        }

        public boolean isSolarisOS() {
            return this == SOLARIS;
        }

        public boolean isMacOS() {
            return this == MAC;
        }
    }
}

