/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.utils.cmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.reviews.r4e.core.Activator;
import org.eclipse.mylyn.reviews.r4e.core.utils.cmd.StreamThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellCommandManager {
    private File cmdPath;
    private boolean receivedCancellation = false;
    private Boolean waitforCompletion = false;
    private Process process = null;
    private StreamThread outputStream = null;
    private StreamThread errorStream = null;
    private List<String> command = null;
    private List<String> listResult = null;
    List<String> results = null;
    int executedCount = 0;
    int processExitValue = -1;
    private int intervals = 10;
    private int msSleep = 10;

    public ShellCommandManager(String commandPath, List<String> rcommand) {
        this.cmdPath = commandPath == null ? null : new File(commandPath);
        this.command = rcommand;
    }

    public int execute() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new StreamThread();
        }
        if (this.errorStream == null) {
            this.errorStream = new StreamThread();
        }
        this.intervals = 72000;
        this.msSleep = 250;
        return this.execute(this.outputStream, this.errorStream, this.waitforCompletion);
    }

    public int execute(StreamThread outputStream, StreamThread errorStream, boolean waitfor) throws IOException {
        this.outputStream = outputStream;
        this.errorStream = errorStream;
        this.waitforCompletion = waitfor;
        this.processExitValue = waitfor ? -1 : 0;
        ProcessBuilder pb = new ProcessBuilder(this.command);
        if (this.cmdPath != null) {
            pb.directory(this.cmdPath);
        }
        try {
            this.process = pb.start();
            if (outputStream != null) {
                outputStream.setStream(this.process.getInputStream());
                outputStream.start();
            }
            if (errorStream != null) {
                errorStream.setStream(this.process.getErrorStream());
                errorStream.start();
            }
            if (waitfor) {
                this.processExitValue = this.process.waitFor();
            }
            int iwaitCnt = 0;
            while (errorStream != null && errorStream.isAlive() && iwaitCnt < this.intervals && !this.receivedCancellation) {
                ++iwaitCnt;
                Thread.sleep(this.msSleep);
            }
            Activator.fTracer.traceInfo("\nWaited " + iwaitCnt * this.msSleep + " ms to read the errorStream");
            iwaitCnt = 0;
            while (outputStream != null && outputStream.isAlive() && iwaitCnt < this.intervals && !this.receivedCancellation) {
                ++iwaitCnt;
                Thread.sleep(this.msSleep);
            }
            Activator.fTracer.traceInfo("\nWaited " + iwaitCnt * this.msSleep + " ms to read the outputStream");
            Activator.fTracer.traceInfo("Returning with exitValue " + this.processExitValue + "  \"waitfor\"=" + waitfor + "\npath:" + this.cmdPath + "\n" + this.command.toString());
            if (this.receivedCancellation) {
                Activator.fTracer.traceInfo("\nShellCommandManager.execute : Cancellation Order Received");
            }
            ++this.executedCount;
        }
        catch (InterruptedException e) {
            Activator.fTracer.traceInfo("ShellCommandManager.execute() InterruptedException:" + e.getMessage());
            e.printStackTrace();
        }
        return this.processExitValue;
    }

    public void cancelExecution() {
        this.receivedCancellation = true;
        if (this.process != null) {
            this.process.destroy();
        }
        Activator.fTracer.traceInfo("Cancelling execution for : " + this.command.toString() + " at " + this.cmdPath);
    }

    public boolean isCancelled() {
        return this.receivedCancellation;
    }

    public List<String> getResults(boolean notifyIfError) throws IOException {
        if (this.executedCount == 0) {
            return null;
        }
        if (this.outputStream == null) {
            Activator.fTracer.traceInfo("ShellCommandManager.getResults() outputStream is NULL");
            return null;
        }
        if (this.errorStream == null) {
            Activator.fTracer.traceInfo("ShellCommandManager.getResults() errorStream is NULL");
            return null;
        }
        if (!this.outputStream.isAlive() && !this.errorStream.isAlive()) {
            String str = "ShellCommandManager.getResults() outputStream  + errorStream CLOSED properly, Java Process exit value: ";
            Activator.fTracer.traceInfo(String.valueOf(str) + this.processExitValue);
        } else {
            if (this.outputStream.isAlive()) {
                Activator.fTracer.traceInfo("ShellCommandManager.getResults() outputStream is alive: Java Process exit value: " + this.processExitValue);
            }
            if (this.errorStream.isAlive()) {
                Activator.fTracer.traceInfo("ShellCommandManager.getResults() errorStream is alive: Java Process exit value: " + this.processExitValue);
            }
        }
        if (notifyIfError) {
            List<String> lines = this.errorStream.getLines();
            if (lines == null) {
                Activator.fTracer.traceInfo("ShellCommandManager.getResults() error stream lines size: NULL");
            } else {
                Activator.fTracer.traceInfo("ShellCommandManager.getResults() error stream lines size: " + lines.size());
            }
            if (lines != null && lines.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String s : lines) {
                    sb = sb.append(String.valueOf(s) + "\n");
                }
                Activator.fTracer.traceInfo("ShellCommandManager.getResults() " + sb);
                throw new IOException("R4E reporting error when attempting to execute command. Operation could not be completed. " + this.command.toString() + "\n" + sb);
            }
        }
        return this.outputStream.getLines();
    }

    public void setSVNResult(List<String> result) {
        this.listResult = result;
    }

    public List<String> getSVNResult() {
        return this.listResult;
    }

    public static void main(String[] args) {
        String command3 = new String("cleardiff -blank_ignore -diff_format /view/Alvaro Sanchez-Leon_svp1code_lvb/vobs/r4ecode/dev/r4e/src/com/ericsson/r4e/core/header/column/UserNameTableModel.java@@/main/svp1code/svp1code_lvb/0 /view/Alvaro Sanchez-Leon_svp1code_lvb/vobs/r4ecode/dev/r4e/src/com/ericsson/r4e/core/header/column/UserNameTableModel.java@@/main/svp1code/svp1code_lvb/1");
        String command4 = new String("cleardiff -blank_ignore -diff_format /view/Alvaro Sanchez-Leon_svp1code_lvb/vobs/r4ecode/dev/r4e/src/com/ericsson/r4e/core/header/column/UserNameTableModel.java@@/main/svp1code/svp1code_lvb/0 /view/Alvaro Sanchez-Leon_svp1code_lvb/vobs/r4ecode/dev/r4e/src/com/ericsson/r4e/core/header/column/UserNameTableModel.java@@/main/svp1code/svp1code_lvb/1");
        String[] cmd3 = command3.split(" ");
        String[] cmd4 = command4.split(" ");
        List<Object> outputLines = new ArrayList();
        StreamThread outputStream = new StreamThread();
        StreamThread errorStream = new StreamThread();
        List<String> command = Arrays.asList(cmd3);
        int status = 0;
        long elapsedTime = 0L;
        long startTime = System.currentTimeMillis();
        ShellCommandManager manager = new ShellCommandManager(null, command);
        try {
            status = manager.execute(outputStream, errorStream, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        elapsedTime = System.currentTimeMillis() - startTime;
        Activator.fTracer.traceInfo("exec() status " + status + ", elapsed time " + elapsedTime);
        startTime = System.currentTimeMillis();
        outputLines = outputStream.getLines();
        elapsedTime = System.currentTimeMillis() - startTime;
        Activator.fTracer.traceInfo("exec() result time " + elapsedTime);
        if (outputStream.isAlive() || outputStream.isAlive()) {
            System.err.println("exec() outputStream alive ");
        }
        for (String string : outputLines) {
            Activator.fTracer.traceInfo(">" + string);
        }
        StreamThread streamThread = new StreamThread();
        StreamThread errorStream4 = new StreamThread();
        command = Arrays.asList(cmd4);
        status = 0;
        elapsedTime = 0L;
        startTime = System.currentTimeMillis();
        manager = new ShellCommandManager(null, command);
        try {
            status = manager.execute(streamThread, errorStream4, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        elapsedTime = System.currentTimeMillis() - startTime;
        Activator.fTracer.traceInfo("exec() status " + status + ", elapsed time " + elapsedTime);
        startTime = System.currentTimeMillis();
        outputLines = outputStream.getLines();
        elapsedTime = System.currentTimeMillis() - startTime;
        Activator.fTracer.traceInfo("exec() result time " + elapsedTime);
        if (outputStream.isAlive() || outputStream.isAlive()) {
            System.err.println("exec() outputStream alive ");
        }
        for (String string : outputLines) {
            Activator.fTracer.traceInfo(">" + string);
        }
        StreamThread streamThread2 = new StreamThread();
        StreamThread errorStream2 = new StreamThread();
        try {
            Activator.fTracer.traceInfo("exec() status " + manager.execute(streamThread2, errorStream2, true));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (streamThread2.isAlive() || streamThread2.isAlive()) {
            System.err.println("exec() outputStream alive ");
        }
        outputLines = streamThread2.getLines();
        for (String string : outputLines) {
            Activator.fTracer.traceInfo(">" + string);
        }
    }
}

