/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.utils.cmd;

import java.io.IOException;
import java.util.List;
import org.eclipse.mylyn.reviews.r4e.core.Activator;
import org.eclipse.mylyn.reviews.r4e.core.utils.cmd.ShellCommandManager;
import org.eclipse.mylyn.reviews.r4e.core.utils.cmd.StreamThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSupportCommand {
    protected String executeWithStringReturned(String cmdPath, List<String> command, boolean waitFor, boolean errorNotified) throws IOException {
        List<String> results = this.execute(cmdPath, command, waitFor, errorNotified);
        if (results == null || results.size() == 0) {
            Activator.fTracer.traceInfo("execute received no results");
            return new String("");
        }
        StringBuilder result = new StringBuilder();
        int maxLines = results.size() > 10 ? 10 : results.size();
        int i = 0;
        while (i < maxLines) {
            result.append(results.get(i));
            ++i;
        }
        return result.toString();
    }

    private List<String> execute(String cmdPath, List<String> command, boolean waitFor, boolean notifyIfError) throws IOException {
        List<String> lines;
        List<String> results = null;
        ShellCommandManager manager = new ShellCommandManager(cmdPath, command);
        StreamThread outputStream = new StreamThread();
        StreamThread errorStream = new StreamThread();
        Activator.fTracer.traceInfo("Command Path: " + cmdPath + "\n" + command.toString());
        int exitValue = manager.execute(outputStream, errorStream, waitFor);
        StringBuilder str = new StringBuilder();
        if (!outputStream.isAlive() && !errorStream.isAlive()) {
            str.append("outputStream  + errorStream CLOSED properly, Java Process exit value: ");
            Activator.fTracer.traceInfo(String.valueOf(str.toString()) + exitValue);
        } else {
            if (outputStream.isAlive()) {
                str.append("outputStream is alive: Java Process exit value: " + exitValue);
            }
            if (errorStream.isAlive()) {
                str.append("\nerrorStream is alive: Java Process exit value: " + exitValue);
                Activator.fTracer.traceInfo(str.toString());
            }
        }
        results = exitValue == 0 ? outputStream.getLines() : errorStream.getLines();
        if (notifyIfError && (lines = errorStream.getLines()).size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : lines) {
                sb = sb.append(String.valueOf(s) + "\n");
            }
            sb.append("Path: " + cmdPath + "\n");
            sb.append("Command: \n");
            sb.append(command.toString());
            Activator.fTracer.traceInfo(sb.toString());
            if (exitValue != 5) {
                throw new IOException("R4E - Unable to perform operation: \n" + sb.toString());
            }
        }
        return results;
    }
}

